/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.core.api.transaction.xa.ResourceManagerException;
import org.mule.runtime.core.internal.transaction.xa.AbstractTransactionContext;
import org.mule.runtime.core.internal.util.journal.queue.LocalTxQueueTransactionJournal;
import org.mule.runtime.core.internal.util.queue.LocalQueueTransactionContext;
import org.mule.runtime.core.internal.util.queue.PersistentQueueTransactionContext;
import org.mule.runtime.core.internal.util.queue.QueueProvider;
import org.mule.runtime.core.internal.util.queue.QueueStore;
import org.mule.runtime.core.internal.util.queue.QueueTransactionContextFactory;
import org.mule.runtime.core.internal.util.queue.QueueTypeTransactionContextAdapter;
import org.mule.runtime.core.internal.util.queue.TransientQueueTransactionContext;

public class LocalTxQueueTransactionContext
extends AbstractTransactionContext
implements LocalQueueTransactionContext,
QueueTransactionContextFactory<LocalQueueTransactionContext> {
    private final LocalTxQueueTransactionJournal localTxQueueTransactionJournal;
    private final QueueProvider queueProvider;
    private final QueueTypeTransactionContextAdapter<LocalQueueTransactionContext> delegate;
    private final Lock transactionContextAccessLock;

    public LocalTxQueueTransactionContext(LocalTxQueueTransactionJournal localTxQueueTransactionJournal, QueueProvider queueProvider, Lock transactionContextAccessLock) {
        this.localTxQueueTransactionJournal = localTxQueueTransactionJournal;
        this.queueProvider = queueProvider;
        this.transactionContextAccessLock = transactionContextAccessLock;
        this.delegate = new QueueTypeTransactionContextAdapter<LocalQueueTransactionContext>(this);
    }

    @Override
    public LocalQueueTransactionContext createPersistentTransactionContext() {
        return new PersistentQueueTransactionContext(this.localTxQueueTransactionJournal, this.queueProvider);
    }

    @Override
    public LocalQueueTransactionContext createTransientTransactionContext() {
        return new TransientQueueTransactionContext();
    }

    @Override
    public void doCommit() throws ResourceManagerException {
        LocalQueueTransactionContext transactionContext = this.delegate.getTransactionContext();
        if (transactionContext != null) {
            transactionContext.doCommit();
        }
    }

    @Override
    public void doRollback() throws ResourceManagerException {
        LocalQueueTransactionContext transactionContext = this.delegate.getTransactionContext();
        if (transactionContext != null) {
            transactionContext.doRollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(QueueStore queue, Serializable item, long offerTimeout) throws InterruptedException {
        long beginMillis = System.currentTimeMillis();
        boolean lockAcquired = this.transactionContextAccessLock.tryLock(offerTimeout, TimeUnit.MILLISECONDS);
        if (lockAcquired) {
            try {
                long remainingTimeout = this.getRemainingTimeout(offerTimeout, beginMillis);
                if (remainingTimeout >= 0L) {
                    boolean bl = this.delegate.offer(queue, item, remainingTimeout);
                    return bl;
                }
            }
            finally {
                this.transactionContextAccessLock.unlock();
            }
        }
        return false;
    }

    @Override
    public void untake(QueueStore queue, Serializable item) throws InterruptedException {
        this.transactionContextAccessLock.lock();
        try {
            this.delegate.untake(queue, item);
        }
        finally {
            this.transactionContextAccessLock.unlock();
        }
    }

    @Override
    public void clear(QueueStore queue) throws InterruptedException {
        this.transactionContextAccessLock.lock();
        try {
            this.delegate.clear(queue);
        }
        finally {
            this.transactionContextAccessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable poll(QueueStore queue, long pollTimeout) throws InterruptedException {
        long beginMillis = System.currentTimeMillis();
        boolean lockAcquired = this.transactionContextAccessLock.tryLock(pollTimeout, TimeUnit.MILLISECONDS);
        if (lockAcquired) {
            try {
                long remainingTimeout = this.getRemainingTimeout(pollTimeout, beginMillis);
                if (remainingTimeout >= 0L) {
                    Serializable serializable = this.delegate.poll(queue, remainingTimeout);
                    return serializable;
                }
            }
            finally {
                this.transactionContextAccessLock.unlock();
            }
        }
        return null;
    }

    @Override
    public Serializable peek(QueueStore queue) throws InterruptedException {
        this.transactionContextAccessLock.lock();
        try {
            Serializable serializable = this.delegate.peek(queue);
            return serializable;
        }
        finally {
            this.transactionContextAccessLock.unlock();
        }
    }

    @Override
    public int size(QueueStore queue) {
        this.transactionContextAccessLock.lock();
        try {
            int n = this.delegate.size(queue);
            return n;
        }
        finally {
            this.transactionContextAccessLock.unlock();
        }
    }

    private long getRemainingTimeout(long originalTimeout, long beginMillis) {
        if (originalTimeout == 0L) {
            return 0L;
        }
        long elapsedMillis = System.currentTimeMillis() - beginMillis;
        return originalTimeout - elapsedMillis;
    }
}

