/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponse;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.sse.server.SseClient;
import org.mule.runtime.http.api.sse.server.SseClientConfig;
import org.mule.service.http.common.server.sse.SseResponseStarter;
import org.mule.service.http.netty.impl.server.DirectResponseSender;
import org.mule.service.http.netty.impl.server.StreamingResponseSender;
import org.mule.service.http.netty.impl.server.sse.ResponseBodyWriter;
import org.mule.service.http.netty.impl.server.util.HttpParser;
import org.mule.service.http.netty.impl.util.MuleToNettyUtils;

public class NettyHttp1ResponseReadyCallback
implements HttpResponseReadyCallback {
    private static final int MAX_NUM_HEADERS_DEFAULT = 100;
    private static final String MAX_SERVER_RESPONSE_HEADERS_KEY = "mule.http.MAX_SERVER_RESPONSE_HEADERS";
    public static int MAX_SERVER_RESPONSE_HEADERS = Integer.getInteger("mule.http.MAX_SERVER_RESPONSE_HEADERS", 100);
    private final ChannelHandlerContext ctx;
    private final HttpRequest httpRequest;
    private final Executor ioExecutor;

    public NettyHttp1ResponseReadyCallback(ChannelHandlerContext ctx, HttpRequest muleRequest, Executor ioExecutor) {
        this.ctx = ctx;
        this.httpRequest = muleRequest;
        this.ioExecutor = ioExecutor;
    }

    public static void refreshMaxServerResponseHeaders() {
        MAX_SERVER_RESPONSE_HEADERS = Integer.getInteger(MAX_SERVER_RESPONSE_HEADERS_KEY, 100);
    }

    public static int getMaxServerResponseHeaders() {
        return MAX_SERVER_RESPONSE_HEADERS;
    }

    public void responseReady(org.mule.runtime.http.api.domain.message.response.HttpResponse response, ResponseStatusCallback responseStatusCallback) {
        try {
            this.sendResponse(this.ctx, response, responseStatusCallback);
        }
        catch (IOException e) {
            responseStatusCallback.responseSendFailure((Throwable)e);
        }
    }

    public Writer startResponse(org.mule.runtime.http.api.domain.message.response.HttpResponse response, ResponseStatusCallback responseStatusCallback, Charset encoding) {
        HttpResponse nettyResponse = MuleToNettyUtils.adaptResponseWithoutBody(response, this.httpRequest.getProtocol());
        this.ctx.writeAndFlush((Object)nettyResponse);
        return new ResponseBodyWriter(this.ctx, encoding, responseStatusCallback);
    }

    public SseClient startSseResponse(SseClientConfig config) {
        return new SseResponseStarter().startResponse(config, this);
    }

    private void sendResponse(ChannelHandlerContext ctx, org.mule.runtime.http.api.domain.message.response.HttpResponse response, ResponseStatusCallback callback) throws IOException {
        if (response.getHeaders().size() > MAX_SERVER_RESPONSE_HEADERS) {
            throw new IllegalArgumentException("Exceeded max server response headers limit: " + MAX_SERVER_RESPONSE_HEADERS);
        }
        org.mule.runtime.http.api.domain.message.response.HttpResponse httpResponse = response;
        boolean isHeadMethod = this.isHeadMethod(this.httpRequest);
        if (isHeadMethod) {
            httpResponse = NettyHttp1ResponseReadyCallback.buildResponseWithEmptyBody(httpResponse);
        } else if (httpResponse.getEntity().isComposed()) {
            httpResponse = NettyHttp1ResponseReadyCallback.buildMultipartResponse(httpResponse);
        }
        if (httpResponse.getEntity().isStreaming()) {
            new StreamingResponseSender(this.httpRequest, ctx, httpResponse, callback, this.ioExecutor).send();
        } else {
            new DirectResponseSender(this.httpRequest, ctx, httpResponse, callback).send();
        }
        if (isHeadMethod) {
            ctx.close();
        }
    }

    private static org.mule.runtime.http.api.domain.message.response.HttpResponse buildResponseWithEmptyBody(org.mule.runtime.http.api.domain.message.response.HttpResponse response) throws IOException {
        if (response.getEntity().isStreaming()) {
            response.getEntity().getContent().close();
        }
        return ((HttpResponseBuilder)new HttpResponseBuilder(response).entity((HttpEntity)new EmptyHttpEntity())).build();
    }

    private boolean isHeadMethod(HttpRequest httpRequest) {
        return "HEAD".equals(httpRequest.getMethod());
    }

    private static org.mule.runtime.http.api.domain.message.response.HttpResponse buildMultipartResponse(org.mule.runtime.http.api.domain.message.response.HttpResponse response) throws IOException {
        HttpResponseBuilder httpResponseBuilder = new HttpResponseBuilder(response);
        return ((HttpResponseBuilder)httpResponseBuilder.entity((HttpEntity)HttpParser.fromMultipartEntity(response.getHeaderValue("Content-Type"), (MultipartHttpEntity)response.getEntity(), ct -> {
            httpResponseBuilder.removeHeader("Content-Type");
            httpResponseBuilder.addHeader("Content-Type", ct);
        }, Collections.emptyMap()))).build();
    }

    private static String generateBoundary() {
        return "----MuleMultipart" + UUID.randomUUID().toString().replace("-", "");
    }
}

