/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.tracing.event.span.condition;

import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.tracer.api.span.validation.Assertion;
import org.mule.runtime.tracer.api.span.validation.AssertionFailedException;

public class SpanNameAssertion
implements Assertion {
    private final String spanExpectedName;

    public SpanNameAssertion(String spanExpectedName) {
        this.spanExpectedName = spanExpectedName;
    }

    public void assertOnSpan(Span span) throws AssertionFailedException {
        if (span == null) {
            throw new AssertionFailedException("The span is null. Expected a span with name: " + this.spanExpectedName);
        }
        String spanName = span.getName();
        if (!this.spanExpectedName.equals(spanName)) {
            throw new AssertionFailedException("The span has name: " + spanName + ".  Expected a span with name: " + this.spanExpectedName);
        }
    }
}

