/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.core.io;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0005\n\u0001?!Aa\u0005\u0001BC\u0002\u0013\u0005q\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003)\u0011!a\u0003A!b\u0001\n\u00039\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u000b9\u0002A\u0011A\u0018\t\u000fQ\u0002!\u0019!C\u0007k!1a\t\u0001Q\u0001\u000eYBqa\u0012\u0001C\u0002\u0013%\u0001\n\u0003\u0004P\u0001\u0001\u0006I!\u0013\u0005\u0006!\u0002!\t!\u0015\u0005\u0006%\u0002!\ta\u0015\u0005\u00063\u0002!\tA\u0017\u0005\u00067\u0002!I!\u0015\u0005\u00069\u0002!I!\u0018\u0005\u0006?\u0002!\t\u0001\u0019\u0005\u0006E\u0002!\ta\u0019\u0002\u000f\u0005f$XMQ;gM\u0016\u0014\bk\\8m\u0015\t\u0019B#\u0001\u0002j_*\u0011QCF\u0001\u0005G>\u0014XM\u0003\u0002\u00181\u0005\u0011aO\r\u0006\u00033i\tQa^3bm\u0016T!a\u0007\u000f\u0002\t5,H.\u001a\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0002\u0013}\u001b\u0017\r]1dSRLX#\u0001\u0015\u0011\u0005\u0005J\u0013B\u0001\u0016#\u0005\rIe\u000e^\u0001\u000b?\u000e\f\u0007/Y2jif\u0004\u0013\u0001C0nCb\u001c\u0016N_3\u0002\u0013}k\u0017\r_*ju\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u00021eM\u0002\"!\r\u0001\u000e\u0003IAQAJ\u0003A\u0002!BQ\u0001L\u0003A\u0002!\naaX9vKV,W#\u0001\u001c\u0011\u0007]r\u0004)D\u00019\u0015\tI$(\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u000f\u001f\u0002\tU$\u0018\u000e\u001c\u0006\u0002{\u0005!!.\u0019<b\u0013\ty\u0004HA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fI\u0012+\u0017/^3\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rc\u0014a\u00018j_&\u0011QI\u0011\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018aB0rk\u0016,X\rI\u0001\u0007C6|WO\u001c;\u0016\u0003%\u0003\"AS'\u000e\u0003-S!\u0001\u0014\u001d\u0002\r\u0005$x.\\5d\u0013\tq5JA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\bC6|WO\u001c;!\u0003\u0011!\u0018m[3\u0015\u0003\u0001\u000bqA]3mK\u0006\u001cX\r\u0006\u0002U/B\u0011\u0011%V\u0005\u0003-\n\u0012A!\u00168ji\")\u0001l\u0003a\u0001\u0001\u00061!-\u001e4gKJ\fAa]5{KR\t\u0001&A\u0005rk\u0016,X\rU8mY\u0006Q\u0011/^3vK>3g-\u001a:\u0015\u0005Qs\u0006\"\u0002-\u000f\u0001\u0004\u0001\u0015!B2mK\u0006\u0014HC\u0001+b\u0011\u0015Av\u00021\u0001A\u0003\u001dI7/R7qif,\u0012\u0001\u001a\t\u0003C\u0015L!A\u001a\u0012\u0003\u000f\t{w\u000e\\3b]\u0002")
public class ByteBufferPool {
    private final int _capacity;
    private final int _maxSize;
    private final ConcurrentLinkedDeque<ByteBuffer> _queue;
    private final AtomicInteger amount;

    public int _capacity() {
        return this._capacity;
    }

    public int _maxSize() {
        return this._maxSize;
    }

    private final ConcurrentLinkedDeque<ByteBuffer> _queue() {
        return this._queue;
    }

    private AtomicInteger amount() {
        return this.amount;
    }

    public ByteBuffer take() {
        ByteBuffer buffer = this.queuePoll();
        if (buffer == null) {
            if (this.amount().incrementAndGet() <= this._maxSize()) {
                return ByteBuffer.allocateDirect(this._capacity());
            }
            this.amount().decrementAndGet();
            return null;
        }
        buffer.limit(this._capacity());
        return buffer;
    }

    public void release(ByteBuffer buffer) {
        this.queueOffer(buffer);
    }

    public int size() {
        return this._queue().size();
    }

    private ByteBuffer queuePoll() {
        ByteBuffer poll = this._queue().poll();
        return poll;
    }

    private void queueOffer(ByteBuffer buffer) {
        this.clear(buffer);
        this._queue().offerFirst(buffer);
    }

    public void clear(ByteBuffer buffer) {
        buffer.clear();
        buffer.limit(0);
    }

    public boolean isEmpty() {
        return this._queue().isEmpty();
    }

    public ByteBufferPool(int _capacity, int _maxSize) {
        this._capacity = _capacity;
        this._maxSize = _maxSize;
        this._queue = new ConcurrentLinkedDeque();
        this.amount = new AtomicInteger();
    }
}

