/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.annotation;

import java.util.Objects;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.utils.MetadataTypeUtils;

public class NumberRangeAnnotation
implements TypeAnnotation {
    public static final String NAME = "range";
    private final Number from;
    private final Number to;

    public NumberRangeAnnotation(Number from, Number to) {
        this.from = from;
        this.to = to;
    }

    public Optional<Number> getFrom() {
        return Optional.ofNullable(this.from);
    }

    public Optional<Number> getTo() {
        return Optional.ofNullable(this.to);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NumberRangeAnnotation) {
            NumberRangeAnnotation other = (NumberRangeAnnotation)obj;
            return Objects.equals(this.getFrom(), other.getFrom()) && Objects.equals(this.getTo(), other.getTo());
        }
        return false;
    }

    public int hashCode() {
        return MetadataTypeUtils.hashCode(this.getFrom(), this.getTo());
    }
}

