/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactAstSerializerMetadataSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactAstSerializerMetadataSerializer.class);
    public static final char END_HEADER_DELIMITER = '\n';
    private static final int MAX_HEADER_LINE_LENGTH = 1001;
    public static final String DELIMITER = "#";

    public ArtifactAstSerializerMetadata readArtifactAstSerializerMetadataFromInputStream(InputStream inputStream) throws IOException {
        String headerString = this.getHeaderString(inputStream);
        String[] split = headerString.split(DELIMITER);
        if (split.length < 3) {
            throw new IllegalArgumentException("The serialized artifact input stream has an invalid header: " + headerString);
        }
        String serializerVersion = split[1];
        if (split.length > 3) {
            LOGGER.warn("Unrecognized extra header fields: '" + Stream.of(split).skip(3L).collect(Collectors.toList()) + "'. Maybe it was generated by a newer serializer version (" + serializerVersion + ")?");
        }
        return new ArtifactAstSerializerMetadata(split[0], serializerVersion, this.getCharsetForName(split[2]));
    }

    private String getHeaderString(InputStream inputStream) throws IOException {
        char c;
        int intC;
        int index;
        char[] characters = new char[1001];
        for (index = 0; (intC = inputStream.read()) != -1 && index < 1001 && (c = (char)intC) != '\n'; ++index) {
            characters[index] = c;
        }
        return new String(characters, 0, index);
    }

    private Charset getCharsetForName(String charsetName) {
        try {
            return Charset.forName(charsetName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The serialized artifact input stream has an invalid header: " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
    }

    public InputStream addArtifactAstSerializerMetadataToInputStream(InputStream inputStream, ArtifactAstSerializerMetadata artifactAstSerializerMetadata) {
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(artifactAstSerializerMetadata, "artifactAstSerializerMetadata");
        String headerString = artifactAstSerializerMetadata.getSerializerId() + DELIMITER + artifactAstSerializerMetadata.getSerializerVersion() + DELIMITER + artifactAstSerializerMetadata.getCharset().name() + DELIMITER + '\n';
        InputStream headerInputStream = IOUtils.toInputStream((String)headerString, (Charset)StandardCharsets.UTF_8);
        return new SequenceInputStream(headerInputStream, inputStream);
    }
}

