/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client.sse;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.http.api.sse.ServerSentEvent;
import org.mule.runtime.http.api.sse.client.SseListener;
import org.mule.service.http.common.client.sse.ServerSentEventDataListener;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import org.mule.service.http.test.netty.utils.sse.ServerSentEventTypeSafeMatcher;

@Feature(value="Server Sent Events (SSE)")
@Story(value="SSE Source")
public class ServerSentEventDataListenerTestCase
extends AbstractHttpTestCase {
    private SseListener eventListener;
    private ServerSentEventDataListener dataListener;

    @Before
    public void setUp() {
        this.eventListener = (SseListener)Mockito.mock(SseListener.class);
        this.dataListener = new ServerSentEventDataListener(this.eventListener, "TestClient");
    }

    @Test
    public void happyPathDecode() {
        ArgumentCaptor eventsCaptor = ArgumentCaptor.forClass(ServerSentEvent.class);
        ServerSentEventDataListenerTestCase.feedListener(this.dataListener, "event: message\ndata: message1; line1\ndata: message1; line2\nid: message1\n\nevent: message\ndata: message2; line1\ndata: message2; line2\nid: message2\nretry: 1000\n\n");
        ((SseListener)Mockito.verify((Object)this.eventListener, (VerificationMode)Mockito.times((int)2))).onEvent((ServerSentEvent)eventsCaptor.capture());
        ((SseListener)Mockito.verify((Object)this.eventListener)).onClose();
        MatcherAssert.assertThat((Object)eventsCaptor.getAllValues(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ServerSentEventTypeSafeMatcher.aServerSentEvent("message", "message1; line1\nmessage1; line2", "message1", null), ServerSentEventTypeSafeMatcher.aServerSentEvent("message", "message2; line1\nmessage2; line2", "message2", 1000L)}));
    }

    @Test
    public void dataWithEmptyLines() {
        ArgumentCaptor eventsCaptor = ArgumentCaptor.forClass(ServerSentEvent.class);
        ServerSentEventDataListenerTestCase.feedListener(this.dataListener, "event: message\ndata: message1; line1\ndata:\ndata: message1; line3\n\n");
        ((SseListener)Mockito.verify((Object)this.eventListener)).onEvent((ServerSentEvent)eventsCaptor.capture());
        ((SseListener)Mockito.verify((Object)this.eventListener)).onClose();
        ServerSentEvent event = (ServerSentEvent)eventsCaptor.getValue();
        MatcherAssert.assertThat((Object)event, (Matcher)Matchers.is(ServerSentEventTypeSafeMatcher.aServerSentEvent("message", "message1; line1\n\nmessage1; line3")));
    }

    @Test
    public void retryIsNotANumber() {
        ArgumentCaptor eventsCaptor = ArgumentCaptor.forClass(ServerSentEvent.class);
        ServerSentEventDataListenerTestCase.feedListener(this.dataListener, "event: message\ndata: data\nretry: thisIsAString\n\n");
        ((SseListener)Mockito.verify((Object)this.eventListener)).onEvent((ServerSentEvent)eventsCaptor.capture());
        ((SseListener)Mockito.verify((Object)this.eventListener)).onClose();
        ServerSentEvent eventParsed = (ServerSentEvent)eventsCaptor.getValue();
        MatcherAssert.assertThat((Object)eventParsed, (Matcher)Matchers.is(ServerSentEventTypeSafeMatcher.aServerSentEvent("message", "data")));
        MatcherAssert.assertThat((String)"Retry should be ignored because it is not a number", (Object)eventParsed.getRetryDelay().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void unexpectedEventFieldIsJustIgnored() {
        ArgumentCaptor eventsCaptor = ArgumentCaptor.forClass(ServerSentEvent.class);
        ServerSentEventDataListenerTestCase.feedListener(this.dataListener, "event: message\ndata: data\nthisIsNotExpected: irrelevantValue\n\n");
        ((SseListener)Mockito.verify((Object)this.eventListener)).onEvent((ServerSentEvent)eventsCaptor.capture());
        ((SseListener)Mockito.verify((Object)this.eventListener)).onClose();
        ServerSentEvent eventParsed = (ServerSentEvent)eventsCaptor.getValue();
        MatcherAssert.assertThat((Object)eventParsed, (Matcher)Matchers.is(ServerSentEventTypeSafeMatcher.aServerSentEvent("message", "data")));
    }

    @Test
    public void streamHasLessBytesThanExpectedSoItReadsWhatItHas() throws IOException {
        String payload = "payload";
        ByteArrayInputStream stream = new ByteArrayInputStream(payload.getBytes(StandardCharsets.UTF_8));
        MatcherAssert.assertThat((Object)((InputStream)stream).available(), (Matcher)Matchers.is((Object)payload.length()));
        this.dataListener.onStreamCreated((InputStream)stream);
        this.dataListener.onDataAvailable(payload.length() + 1);
        MatcherAssert.assertThat((Object)((InputStream)stream).available(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void streamThrowsIOException() throws IOException {
        InputStream stream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)stream.read((byte[])ArgumentMatchers.any())).thenThrow(IOException.class);
        this.dataListener.onStreamCreated(stream);
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.dataListener.onDataAvailable(5));
        MatcherAssert.assertThat((Object)exception, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Exception parsing events stream")));
    }

    private static void feedListener(ServerSentEventDataListener sseDataListener, String payload) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(payload.getBytes(StandardCharsets.UTF_8));
        int length = payload.length();
        int chunkLength = 10;
        int numberOfCompleteChunks = length / chunkLength;
        int extraChunkLength = length % chunkLength;
        sseDataListener.onStreamCreated((InputStream)inputStream);
        for (int i = 0; i < numberOfCompleteChunks; ++i) {
            sseDataListener.onDataAvailable(chunkLength);
        }
        sseDataListener.onDataAvailable(extraChunkLength);
        sseDataListener.onEndOfStream();
    }
}

