/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.internal.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.mule.runtime.module.artifact.api.classloader.ExportedService;
import org.mule.runtime.module.artifact.internal.util.JarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarInfo;

public class FileJarExplorer
implements JarExplorer {
    protected static final String CLASS_EXTENSION = ".class";
    private static final String META_INF_SERVICES_PATH = "META-INF/services/";
    private static final Pattern SLASH_PATTERN = Pattern.compile("/");
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile(Pattern.quote(File.separator));
    private final boolean runtimeModeForServices;

    public FileJarExplorer(boolean runtimeModeForServices) {
        this.runtimeModeForServices = runtimeModeForServices;
    }

    public FileJarExplorer() {
        this(true);
    }

    @Override
    public JarInfo explore(URI library) {
        ArrayList<ExportedService> services;
        TreeSet<String> resources;
        TreeSet<String> packages;
        block15: {
            TreeSet<String> rawPackages = new TreeSet<String>();
            packages = new TreeSet<String>();
            resources = new TreeSet<String>();
            services = new ArrayList<ExportedService>();
            try {
                File libraryFile = new File(library);
                if (!libraryFile.exists()) {
                    throw new IllegalArgumentException("Library file does not exists: " + String.valueOf(library));
                }
                if (libraryFile.isDirectory()) {
                    Collection files = FileUtils.listFiles((File)libraryFile, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.INSTANCE);
                    for (File classFile : files) {
                        String relativePath = classFile.getAbsolutePath().substring(libraryFile.getAbsolutePath().length() + 1);
                        if (relativePath.indexOf(File.separatorChar) > 0 && relativePath.endsWith(CLASS_EXTENSION)) {
                            packages.add(SEPARATOR_PATTERN.matcher(relativePath.substring(0, relativePath.lastIndexOf(File.separatorChar))).replaceAll("."));
                            continue;
                        }
                        if (File.separatorChar == '/') {
                            resources.add(relativePath);
                            continue;
                        }
                        resources.add(SEPARATOR_PATTERN.matcher(relativePath).replaceAll("/"));
                    }
                    break block15;
                }
                if (!libraryFile.getName().toLowerCase().endsWith(".jar")) break block15;
                try (ZipFile zipFile = new ZipFile(libraryFile);){
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (entry.isDirectory()) continue;
                        if (this.runtimeModeForServices && name.startsWith(META_INF_SERVICES_PATH)) {
                            String serviceInterface = name.substring(META_INF_SERVICES_PATH.length());
                            URL resource = FileJarExplorer.getServiceResourceUrl(libraryFile.toURI().toURL(), name);
                            services.add(new ExportedService(serviceInterface, resource));
                            continue;
                        }
                        if (name.endsWith(CLASS_EXTENSION)) {
                            int lastIndexOfSlash = name.lastIndexOf(47);
                            if (lastIndexOfSlash < 0 || !rawPackages.add(name.substring(0, lastIndexOfSlash))) continue;
                            packages.add(SLASH_PATTERN.matcher(name.substring(0, lastIndexOfSlash)).replaceAll("."));
                            continue;
                        }
                        resources.add(name);
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot explore URL: " + String.valueOf(library), e);
            }
        }
        return new JarInfo(packages, resources, services);
    }

    public static URL getServiceResourceUrl(URL resource, String serviceInterface) throws MalformedURLException {
        return new URL("jar:" + String.valueOf(resource) + "!/" + serviceInterface);
    }
}

