/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.internal.streaming.MutableStreamingStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CursorProviderJanitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CursorProviderJanitor.class);
    CursorProvider provider;
    private final AtomicInteger openCursorsCount;
    private final MutableStreamingStatistics statistics;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean released = new AtomicBoolean(false);

    public CursorProviderJanitor(CursorProvider provider, AtomicInteger openCursorsCount, MutableStreamingStatistics statistics) {
        this.provider = provider;
        this.openCursorsCount = openCursorsCount;
        this.statistics = statistics;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.provider.close();
            }
            finally {
                if (this.statistics != null) {
                    this.statistics.decrementOpenProviders();
                }
            }
        }
    }

    public final void releaseResources() {
        if (!this.released.compareAndSet(false, true)) {
            return;
        }
        try {
            this.close();
        }
        catch (Exception e) {
            LOGGER.warn("Exception was found trying to close CursorProvider. Will try to release its resources anyway", (Throwable)e);
        }
        try {
            this.provider.releaseResources();
        }
        finally {
            if (this.statistics != null) {
                this.statistics.decrementOpenCursors(this.openCursorsCount.get());
            }
            this.provider = null;
        }
    }

    public void releaseCursor(Cursor cursor) {
        try {
            if (this.statistics != null) {
                this.statistics.decrementOpenCursors();
            }
            cursor.release();
            if (this.openCursorsCount.decrementAndGet() == 0 && this.provider != null && this.provider.isClosed()) {
                this.releaseResources();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception was found trying to release cursor resources. Execution will continue", (Throwable)e);
        }
    }
}

