/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client;

import io.qameta.allure.Story;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPOutputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.test.common.client.AbstractHttpClientTestCase;
import org.mule.tck.MuleTestUtils;

@Story(value="Client Body Decompression")
public class HttpClientDecompressionTestCase
extends AbstractHttpClientTestCase {
    private static final byte[] TEST_MESSAGE = "This is a regular message.".getBytes();
    private static final byte[] compressedData = HttpClientDecompressionTestCase.compressWithGzip(TEST_MESSAGE);
    private HttpClient httpClient;

    public HttpClientDecompressionTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    protected void refreshPropertiesIfNeeded() {
        NettyHttpClient.refreshSystemProperties();
    }

    @After
    public void stopClient() {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
        this.refreshPropertiesIfNeeded();
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder builder = (HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new ByteArrayHttpEntity(compressedData));
        if (request.getHeaderValue("Accept-Encoding") != null) {
            builder.addHeader("Content-Encoding", "gzip");
        }
        return builder.build();
    }

    @Test
    public void decompressesDataWhenAcceptIsPresent_explicitConfig() throws IOException, TimeoutException {
        this.httpClient = this.createClient(true);
        HttpResponse response = this.httpClient.send(this.createRequest(true));
        MatcherAssert.assertThat((Object)response.getEntity().getBytes(), (Matcher)Matchers.is((Object)TEST_MESSAGE));
    }

    @Test
    public void doesNotDecompressDataWithoutAccept_explicitConfig() throws IOException, TimeoutException {
        this.httpClient = this.createClient(true);
        HttpResponse response = this.httpClient.send(this.createRequest(false));
        MatcherAssert.assertThat((Object)response.getEntity().getBytes(), (Matcher)Matchers.is((Object)compressedData));
    }

    @Test
    public void decompressesDataWhenAcceptIsPresent_withProperty() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.client.decompress", (Object)"true", () -> {
            this.refreshPropertiesIfNeeded();
            this.httpClient = this.createClient(false);
            HttpResponse response = this.httpClient.send(this.createRequest(true));
            MatcherAssert.assertThat((Object)response.getEntity().getBytes(), (Matcher)Matchers.is((Object)TEST_MESSAGE));
        });
    }

    @Test
    public void doesNotDecompressDataWithoutAccept_withProperty() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.client.decompress", (Object)"true", () -> {
            this.refreshPropertiesIfNeeded();
            this.httpClient = this.createClient(false);
            HttpResponse response = this.httpClient.send(this.createRequest(false));
            MatcherAssert.assertThat((Object)response.getEntity().getBytes(), (Matcher)Matchers.is((Object)compressedData));
        });
    }

    private HttpClient createClient(boolean isExplicitDecompress) {
        String name = isExplicitDecompress ? "explicit-decompress-client" : "decompress-with-property-client";
        HttpClientConfiguration.Builder configBuilder = new HttpClientConfiguration.Builder().setName(name);
        if (isExplicitDecompress) {
            configBuilder = configBuilder.setDecompress(Boolean.valueOf(true));
        }
        HttpClient client = this.service.getClientFactory().create(configBuilder.build());
        client.start();
        return client;
    }

    private HttpRequest createRequest(boolean withAcceptEncodingGzip) {
        HttpRequestBuilder builder = HttpRequest.builder().uri(this.getUri());
        if (withAcceptEncodingGzip) {
            builder.addHeader("Accept-Encoding", "gzip");
        }
        return builder.build();
    }

    private static byte[] compressWithGzip(byte[] uncompressedData) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gzipOutputStream.write(uncompressedData);
            gzipOutputStream.flush();
            gzipOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

