/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client;

import io.qameta.allure.Description;
import io.qameta.allure.Story;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.test.common.client.AbstractHttpClientTestCase;

@Story(value="TLS")
public class HttpsClientSimpleTestCase
extends AbstractHttpClientTestCase {
    private static final String PASS = "mulepassword";
    private HttpClient client;

    public HttpsClientSimpleTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void createClient() throws CreateException {
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setTlsContextFactory(TlsContextFactory.builder().trustStorePath("tls/trustStore").trustStorePassword(PASS).build()).setName("simple-client-tls-test").build());
        this.client.start();
    }

    @After
    public void stopClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder response = HttpResponse.builder();
        return ((HttpResponseBuilder)response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).entity((HttpEntity)new StringHttpEntity("OK"))).build();
    }

    @Test
    @Description(value="Send request using TLS")
    public void sendRequestUsingCustomTlsProvider() throws Exception {
        HttpRequestOptions requestOptions = HttpRequestOptions.builder().authentication(HttpAuthentication.basic((String)"user", (String)"password").build()).build();
        HttpResponse response = this.client.send(((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().method(HttpConstants.Method.POST).uri(this.getUri()).addHeader("Transfer-Encoding", "chunked")).entity((HttpEntity)new StringHttpEntity("Hola"))).build(), requestOptions);
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"OK")));
    }

    @Override
    protected HttpServerConfiguration.Builder getServerConfigurationBuilder() throws Exception {
        return super.getServerConfigurationBuilder().setTlsContextFactory(TlsContextFactory.builder().keyStorePath("tls/serverKeystore").keyStorePassword(PASS).keyPassword(PASS).build());
    }

    @Override
    protected String getUri() {
        return super.getUri().replace(HttpConstants.Protocol.HTTP.getScheme(), HttpConstants.Protocol.HTTPS.getScheme());
    }
}

