/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.rx;

import com.google.common.util.concurrent.Futures;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.internal.util.rx.SynchronousScheduledFuture;

public class ImmediateScheduler
implements Scheduler {
    public static final Scheduler IMMEDIATE_SCHEDULER = new ImmediateScheduler();

    private ImmediateScheduler() {
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return SynchronousScheduledFuture.synchronousSchedule(() -> {
            command.run();
            return null;
        }, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return SynchronousScheduledFuture.synchronousSchedule(callable, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        throw new RejectedExecutionException("Cannot schedule recurrent tasks in an ImmediateScheduler.");
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        throw new RejectedExecutionException("Cannot schedule recurrent tasks in an ImmediateScheduler.");
    }

    public void shutdown() {
    }

    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    public boolean isShutdown() {
        return false;
    }

    public boolean isTerminated() {
        return false;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    public <T> Future<T> submit(Callable<T> task) {
        try {
            return Futures.immediateFuture(task.call());
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public <T> Future<T> submit(Runnable task, T result) {
        try {
            task.run();
            return Futures.immediateFuture(result);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public Future<?> submit(Runnable task) {
        try {
            task.run();
            return Futures.immediateFuture(null);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return tasks.stream().map(t -> this.submit((Callable)t)).collect(Collectors.toList());
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return tasks.stream().map(t -> this.submit((Callable)t)).collect(Collectors.toList());
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return tasks.iterator().next().call();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return tasks.iterator().next().call();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public void execute(Runnable command) {
        command.run();
    }

    public ScheduledFuture<?> scheduleWithCronExpression(Runnable command, String cronExpression) {
        throw new RejectedExecutionException("Cannot schedule recurrent tasks in an ImmediateScheduler.");
    }

    public ScheduledFuture<?> scheduleWithCronExpression(Runnable command, String cronExpression, TimeZone timeZone) {
        throw new RejectedExecutionException("Cannot schedule recurrent tasks in an ImmediateScheduler.");
    }

    public void stop() {
    }

    public String getName() {
        return "Immediate Scheduler";
    }
}

