/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Objects;
import org.mule.runtime.api.message.ErrorType;

public class ExceptionMapping
implements Comparable<ExceptionMapping> {
    private Class<? extends Throwable> exceptionType;
    private ErrorType errorType;

    public ExceptionMapping(Class<? extends Throwable> exceptionType, ErrorType errorType) {
        Objects.requireNonNull(exceptionType, "exceptionType type cannot be null");
        Objects.requireNonNull(errorType, "error type cannot be null");
        this.exceptionType = exceptionType;
        this.errorType = errorType;
    }

    public boolean matches(Class<? extends Throwable> exception) {
        return this.exceptionType.isAssignableFrom(exception);
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    public int compareTo(ExceptionMapping exceptionMapping) {
        if (this.exceptionType.equals(exceptionMapping.exceptionType)) {
            return 0;
        }
        if (this.exceptionType.isAssignableFrom(exceptionMapping.exceptionType)) {
            return 1;
        }
        if (exceptionMapping.exceptionType.isAssignableFrom(this.exceptionType)) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        return Objects.hash(this.exceptionType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExceptionMapping other = (ExceptionMapping)obj;
        return Objects.equals(this.exceptionType, other.exceptionType);
    }
}

