/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.json.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.ast.internal.serialization.json.gson.TypedComponentIdentifierJsonDeserializer;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class ComponentLocationJsonDeserializer
implements JsonDeserializer<ComponentLocation> {
    private TypedComponentIdentifierJsonDeserializer componentIdentifierJsonDeserializer = new TypedComponentIdentifierJsonDeserializer();

    public ComponentLocation deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject locationJsonObject = jsonElement.getAsJsonObject();
        Optional<String> name = Optional.ofNullable(locationJsonObject.get("name")).map(JsonElement::getAsString);
        List parts = StreamSupport.stream(locationJsonObject.get("parts").getAsJsonArray().spliterator(), false).map(element -> this.deserializeLocationPart(element.getAsJsonObject(), jsonDeserializationContext)).collect(Collectors.toList());
        JsonElement importChainElement = locationJsonObject.get("importChain");
        List importChain = importChainElement != null ? StreamSupport.stream(importChainElement.getAsJsonArray().spliterator(), false).map(element -> URI.create(element.getAsString())).collect(Collectors.toList()) : Collections.emptyList();
        return new DefaultComponentLocation(name, parts, importChain);
    }

    public DefaultComponentLocation.DefaultLocationPart deserializeLocationPart(JsonObject locationPartJsonObject, JsonDeserializationContext jsonDeserializationContext) {
        JsonElement partPathJsonElement = locationPartJsonObject.get("partPath");
        String partPath = partPathJsonElement != null ? partPathJsonElement.getAsString() : null;
        Optional<TypedComponentIdentifier> partIdentifier = Optional.ofNullable(this.componentIdentifierJsonDeserializer.deserialize(locationPartJsonObject.get("partIdentifier"), (Type)((Object)TypedComponentIdentifier.class), jsonDeserializationContext));
        Optional<String> fileName = Optional.ofNullable(locationPartJsonObject.get("fileName")).map(JsonElement::getAsString);
        OptionalInt lineInFile = OptionalInt.empty();
        JsonElement lineInFileJsonElement = locationPartJsonObject.get("line");
        if (lineInFileJsonElement != null) {
            lineInFile = OptionalInt.of(lineInFileJsonElement.getAsInt());
        }
        OptionalInt startColumn = OptionalInt.empty();
        JsonElement startColumnJsonElement = locationPartJsonObject.get("column");
        if (startColumnJsonElement != null) {
            startColumn = OptionalInt.of(startColumnJsonElement.getAsInt());
        }
        return new DefaultComponentLocation.DefaultLocationPart(partPath, partIdentifier, fileName, lineInFile, startColumn);
    }
}

