/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.serializer;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.mule.metadata.api.annotation.RegexPatternAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.AttributeKeyType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.persistence.serializer.AbstractComplexTypeSerializer;
import org.mule.metadata.persistence.serializer.TypeSerializer;

public class ObjectTypeSerializer
extends AbstractComplexTypeSerializer<ObjectType> {
    private final TypeSerializer<MetadataType> delegate;

    public ObjectTypeSerializer(TypeSerializer<MetadataType> delegate) {
        super("Object");
        this.delegate = delegate;
    }

    @Override
    public void doSerialize(JsonWriter writer, ObjectType objectType, Stack<MetadataType> typeStack) throws IOException {
        if (objectType.isOrdered()) {
            writer.name("ordered").value(true);
        }
        if (objectType.isOpen()) {
            writer.name("open");
            this.delegate.serialize(writer, (MetadataType)objectType.getOpenRestriction().get(), typeStack);
        }
        writer.name("fields");
        writer.beginArray();
        for (ObjectFieldType field : objectType.getFields()) {
            this.writeObjectField(writer, typeStack, field);
        }
        writer.endArray();
    }

    private void writeObjectField(JsonWriter writer, Stack<MetadataType> typeStack, ObjectFieldType field) throws IOException {
        writer.beginObject();
        ObjectKeyType key = field.getKey();
        Set keyAnnotations = key.getAnnotations();
        HashMap<String, String> stringObjectHashMap = new HashMap<String, String>();
        if (field.isRequired()) {
            stringObjectHashMap.put("required", "true");
        }
        if (field.isRepeated()) {
            stringObjectHashMap.put("repeated", "true");
        }
        this.createKeyObject(writer, keyAnnotations, field.getKey(), stringObjectHashMap, typeStack);
        writer.name("model");
        this.delegate.serialize(writer, field.getValue(), typeStack);
        this.writeAnnotations(writer, field.getAnnotations());
        writer.endObject();
    }

    private void createKeyObject(JsonWriter writer, Collection<TypeAnnotation> keyAnnotations, ObjectKeyType key, HashMap<String, String> additionalProperties, Stack<MetadataType> stack) throws IOException {
        String keyString;
        writer.name("key");
        writer.beginObject();
        writer.name("name");
        if (key.isName()) {
            keyString = key.getName().toString();
        } else {
            keyString = key.getPattern().toString();
            RegexPatternAnnotation patternAnnotation = new RegexPatternAnnotation(keyString);
            if (!keyAnnotations.contains(patternAnnotation)) {
                keyAnnotations.add((TypeAnnotation)patternAnnotation);
            }
        }
        writer.value(keyString);
        this.writeAnnotations(writer, keyAnnotations);
        this.createAttributes(writer, key, stack);
        for (Map.Entry<String, String> property : additionalProperties.entrySet()) {
            writer.name(property.getKey()).value(property.getValue());
        }
        writer.endObject();
    }

    private void createAttributes(JsonWriter writer, ObjectKeyType key, Stack<MetadataType> stack) throws IOException {
        Collection attributes = key.getAttributes();
        if (!attributes.isEmpty()) {
            writer.name("attributes");
            writer.beginArray();
            for (AttributeFieldType attribute : attributes) {
                this.createAttribute(writer, attribute, stack);
            }
            writer.endArray();
        }
    }

    private Map<String, String> getAttributeAdditionalProperties(AttributeFieldType attribute) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (attribute.isRequired()) {
            result.put("required", "true");
        }
        return result;
    }

    private void createAttribute(JsonWriter writer, AttributeFieldType attribute, Stack<MetadataType> stack) throws IOException {
        writer.beginObject();
        AttributeKeyType attributeKey = attribute.getKey();
        this.createAttributeKeyObject(writer, attributeKey, this.getAttributeAdditionalProperties(attribute));
        writer.name("model");
        this.delegate.serialize(writer, attribute.getValue(), stack);
        this.writeAnnotations(writer, attribute.getAnnotations());
        writer.endObject();
    }

    private void createAttributeKeyObject(JsonWriter writer, AttributeKeyType key, Map<String, String> additionalProperties) throws IOException {
        String keyString;
        writer.name("key");
        writer.beginObject();
        writer.name("name");
        ArrayList<TypeAnnotation> keyAnnotations = new ArrayList<TypeAnnotation>();
        if (key.isName()) {
            keyString = key.getName().toString();
        } else {
            keyString = key.getPattern().toString();
            RegexPatternAnnotation patternAnnotation = new RegexPatternAnnotation(keyString);
            if (!keyAnnotations.contains(patternAnnotation)) {
                keyAnnotations.add((TypeAnnotation)patternAnnotation);
            }
        }
        writer.value(keyString);
        this.writeAnnotations(writer, keyAnnotations);
        for (Map.Entry<String, String> property : additionalProperties.entrySet()) {
            writer.name(property.getKey()).value(property.getValue());
        }
        writer.endObject();
    }
}

