/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.Condition;
import com.conversantmedia.util.concurrent.ContendedAtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.LockSupport;

public abstract class AbstractWaitingCondition
implements Condition {
    private static final int CACHE_LINE_REFS = ContendedAtomicLong.CACHE_LINE / 8;
    private static final int MAX_WAITERS = 8;
    private static final long WAITER_MASK = 7L;
    private static final long WAIT_TIME = 50L;
    private final LongAdder waitCount = new LongAdder();
    private final AtomicReferenceArray<Thread> waiter = new AtomicReferenceArray(8 + 2 * CACHE_LINE_REFS);
    long r1;
    long r2;
    long r3;
    long r4;
    long r5;
    long r6;
    long r7;
    private long waitCache = 0L;
    long c1;
    long c2;
    long c3;
    long c4;
    long c5;
    long c6;
    long c7;
    long c8;

    @Override
    public abstract boolean test();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitNanos(long timeout) throws InterruptedException {
        try {
            long waitCount;
            long waitSequence = waitCount = this.waitCount.sum();
            this.waitCount.increment();
            this.waitCache = waitCount + 1L;
            long timeNow = System.nanoTime();
            long expires = timeNow + timeout;
            Thread t = Thread.currentThread();
            if (waitCount == 0L) {
                int spin = 0;
                while (this.test() && expires > timeNow && !t.isInterrupted()) {
                    spin = Condition.progressiveYield(spin);
                    timeNow = System.nanoTime();
                }
                if (t.isInterrupted()) {
                    throw new InterruptedException();
                }
                return;
            }
            int spin = 0;
            while (this.test() && !this.waiter.compareAndSet((int)(waitSequence++ & 7L) + CACHE_LINE_REFS, null, t) && expires > timeNow) {
                if (spin < 2000) {
                    spin = Condition.progressiveYield(spin);
                } else {
                    LockSupport.parkNanos(400L);
                }
                timeNow = System.nanoTime();
            }
            while (this.test() && this.waiter.get((int)(waitSequence - 1L & 7L) + CACHE_LINE_REFS) == t && expires > timeNow && !t.isInterrupted()) {
                LockSupport.parkNanos(expires - timeNow >> 2);
                timeNow = System.nanoTime();
            }
            if (t.isInterrupted()) {
                while (!this.waiter.compareAndSet((int)(waitSequence - 1L & 7L) + CACHE_LINE_REFS, t, null) && this.waiter.get(CACHE_LINE_REFS) == t) {
                    LockSupport.parkNanos(50L);
                }
                throw new InterruptedException();
            }
            return;
        }
        finally {
            this.waitCount.decrement();
            this.waitCache = this.waitCount.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() throws InterruptedException {
        try {
            long waitCount;
            long waitSequence = waitCount = this.waitCount.sum();
            this.waitCount.increment();
            this.waitCache = waitCount + 1L;
            Thread t = Thread.currentThread();
            if (waitCount == 0L) {
                int spin = 0;
                while (this.test() && !t.isInterrupted()) {
                    spin = Condition.progressiveYield(spin);
                }
                if (t.isInterrupted()) {
                    throw new InterruptedException();
                }
                return;
            }
            int spin = 0;
            while (this.test() && !this.waiter.compareAndSet((int)(waitSequence++ & 7L) + CACHE_LINE_REFS, null, t) && !t.isInterrupted()) {
                if (spin < 2000) {
                    spin = Condition.progressiveYield(spin);
                    continue;
                }
                LockSupport.parkNanos(400L);
            }
            while (this.test() && this.waiter.get((int)(waitSequence - 1L & 7L) + CACHE_LINE_REFS) == t && !t.isInterrupted()) {
                LockSupport.parkNanos(1000000L);
            }
            if (t.isInterrupted()) {
                while (!this.waiter.compareAndSet((int)(waitSequence - 1L & 7L) + CACHE_LINE_REFS, t, null) && this.waiter.get(CACHE_LINE_REFS) == t) {
                    LockSupport.parkNanos(50L);
                }
                throw new InterruptedException();
            }
            return;
        }
        finally {
            this.waitCount.decrement();
            this.waitCache = this.waitCount.sum();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void signal() {
        block3: {
            if (this.waitCache <= 0L && (this.waitCache = this.waitCount.sum()) <= 0L) break block3;
            waitSequence = 0L;
            do lbl-1000:
            // 3 sources

            {
                if ((t = this.waiter.get((int)(waitSequence++ & 7L) + AbstractWaitingCondition.CACHE_LINE_REFS)) == null) continue;
                if (this.waiter.compareAndSet((int)(waitSequence - 1L & 7L) + AbstractWaitingCondition.CACHE_LINE_REFS, t, null)) {
                    LockSupport.unpark(t);
                } else {
                    LockSupport.parkNanos(50L);
                }
                if ((waitSequence & 7L) != 7L && (this.waitCache = this.waitCount.sum()) != 0L) ** GOTO lbl-1000
                return;
            } while ((waitSequence & 7L) != 7L && (this.waitCache = this.waitCount.sum()) != 0L);
            return;
        }
    }
}

