/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.ParameterResolutionException;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;
import org.mule.runtime.ast.internal.param.ExpressionAwareParameter;
import org.mule.runtime.ast.internal.param.ParamTypeResolvingVisitor;
import org.mule.runtime.extension.api.error.ErrorMapping;

public class DefaultComponentParameterAst
implements ComponentParameterAst,
ExpressionAwareParameter {
    private final String rawValue;
    private final ParameterModel model;
    private final ParameterGroupModel groupModel;
    private final ComponentMetadataAst metadata;
    private final ComponentGenerationInformation generationInformation;
    private final boolean allowsExpressionWithoutMarkers;
    private volatile LazyValue<String> resolved;
    private volatile LazyValue<Either<String, Object>> value;

    public DefaultComponentParameterAst(String rawValue, ParameterModel model, ParameterGroupModel parameterGroupModel, ComponentGenerationInformation generationInformation, PropertiesResolver propertiesResolver, ParameterModelUtils parameterModelUtils) {
        this(rawValue, model, parameterGroupModel, null, generationInformation, propertiesResolver, parameterModelUtils);
    }

    public DefaultComponentParameterAst(String rawValue, ParameterModel model, ParameterGroupModel parameterGroupModel, ComponentMetadataAst metadata, ComponentGenerationInformation generationInformation, PropertiesResolver propertiesResolver, ParameterModelUtils parameterModelUtils) {
        this(rawValue, rawValue, null, model, parameterGroupModel, metadata, generationInformation, propertiesResolver, parameterModelUtils);
    }

    public DefaultComponentParameterAst(ComponentAstBuilder complexValue, ParameterModel model, ParameterGroupModel parameterGroupModel, ComponentMetadataAst metadata, ComponentGenerationInformation generationInformation, PropertiesResolver propertiesResolver, ParameterModelUtils parameterModelUtils) {
        this(null, null, complexValue::build, model, parameterGroupModel, metadata, generationInformation, propertiesResolver, parameterModelUtils);
    }

    public DefaultComponentParameterAst(List<ComponentAstBuilder> complexValue, ParameterModel model, ParameterGroupModel parameterGroupModel, ComponentMetadataAst metadata, ComponentGenerationInformation generationInformation, PropertiesResolver propertiesResolver, ParameterModelUtils parameterModelUtils) {
        this(null, null, () -> complexValue.stream().map(ComponentAstBuilder::build).collect(Collectors.toList()), model, parameterGroupModel, metadata, generationInformation, propertiesResolver, parameterModelUtils);
    }

    public DefaultComponentParameterAst(List<ErrorMapping> complexValue, ParameterModel model, ParameterGroupModel parameterGroupModel, ComponentGenerationInformation generationInformation, PropertiesResolver propertiesResolver, ParameterModelUtils parameterModelUtils) {
        this(null, null, () -> complexValue, model, parameterGroupModel, null, generationInformation, propertiesResolver, parameterModelUtils);
    }

    private DefaultComponentParameterAst(String rawValue, String mappedRawValue, Supplier<Object> complexValue, ParameterModel model, ParameterGroupModel parameterGroupModel, ComponentMetadataAst metadata, ComponentGenerationInformation generationInformation, PropertiesResolver propertiesResolver, ParameterModelUtils parameterModelUtils) {
        this.rawValue = rawValue;
        this.model = model;
        this.groupModel = parameterGroupModel;
        this.metadata = metadata;
        this.generationInformation = generationInformation;
        this.allowsExpressionWithoutMarkers = parameterModelUtils.allowsExpressionWithoutMarkers(model);
        this.resetResolvedParam(rawValue, complexValue, propertiesResolver);
        if (complexValue == null && rawValue != null && MuleAstUtils.hasPropertyPlaceholder(rawValue)) {
            propertiesResolver.onMappingFunctionChanged(() -> this.resetResolvedParam(rawValue, complexValue, propertiesResolver));
        }
    }

    private void resetResolvedParam(String rawValue, Supplier<Object> complexValue, PropertiesResolver propertiesResolver) {
        if (complexValue != null) {
            this.resolved = new LazyValue();
            this.value = new LazyValue(() -> Either.right(complexValue.get()));
        } else {
            this.resolved = rawValue != null && MuleAstUtils.hasPropertyPlaceholder(rawValue) ? new LazyValue(() -> propertiesResolver.apply(rawValue)) : new LazyValue((Object)rawValue);
            this.value = new LazyValue(() -> {
                Object defaultValue;
                String resolvedRawValue = this.getResolvedRawValue();
                if (Objects.isNull(resolvedRawValue) && (defaultValue = this.getModel().getDefaultValue()) != null) {
                    if (defaultValue instanceof String) {
                        resolvedRawValue = (String)defaultValue;
                    } else if (this.getModel().getType().getAnnotation(EnumAnnotation.class).isPresent()) {
                        resolvedRawValue = ((Enum)defaultValue).name();
                    } else {
                        return Either.right((Object)defaultValue);
                    }
                }
                return ParamTypeResolvingVisitor.resolveParamValue(this, this.metadata, resolvedRawValue);
            });
        }
    }

    @Override
    public boolean isExpression(Object value) {
        if (value instanceof String) {
            String trim = ((String)value).trim();
            if (trim.startsWith("#[") && trim.endsWith("]")) {
                return true;
            }
            return this.allowsExpressionWithoutMarkers;
        }
        return false;
    }

    @Override
    public Optional<String> extractExpression(Object value) {
        String expression;
        Optional<String> result = Optional.empty();
        if (this.isExpression(value) && StringUtils.isNotEmpty((CharSequence)(expression = (String)value))) {
            String trimmedText = expression.trim();
            result = trimmedText.startsWith("#[") && trimmedText.endsWith("]") ? Optional.of(trimmedText.substring("#[".length(), trimmedText.length() - "]".length())) : Optional.of(trimmedText);
        }
        return result;
    }

    @Override
    public <T> Either<String, T> getValue() {
        return (Either)this.value.get();
    }

    @Override
    public <T> Either<String, Either<ParameterResolutionException, T>> getValueOrResolutionError() {
        try {
            return this.getValue().mapRight(fixedValue -> Either.right((Object)fixedValue));
        }
        catch (ParameterResolutionException e) {
            return Either.right((Object)Either.left((Object)((Object)e)));
        }
    }

    @Override
    public String getRawValue() {
        return this.rawValue;
    }

    @Override
    public String getResolvedRawValue() {
        return (String)this.resolved.get();
    }

    @Override
    public ParameterModel getModel() {
        return this.model;
    }

    @Override
    public ParameterGroupModel getGroupModel() {
        return this.groupModel;
    }

    @Override
    public Optional<ComponentMetadataAst> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    @Override
    public ComponentGenerationInformation getGenerationInformation() {
        return this.generationInformation;
    }

    @Override
    public boolean isDefaultValue() {
        return Optional.ofNullable(this.getResolvedRawValue()).map(v -> {
            if (this.getModel() != null && this.getModel().getDefaultValue() != null) {
                return v.equals(this.getModel().getDefaultValue());
            }
            return false;
        }).orElse(true);
    }

    public String toString() {
        return "DefaultComponentParameterAst{" + this.model.getName() + ": " + this.rawValue + "}";
    }
}

