/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.benchmark;

import io.qameta.allure.Issue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.test.netty.impl.benchmark.BenchmarkTestServer;
import org.mule.service.http.test.netty.utils.NoOpResponseStatusCallback;
import org.mule.service.http.test.netty.utils.ResponseWithoutHeaders;
import org.mule.tck.junit4.rule.DynamicPort;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Thread)
public class BenchmarkTest {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    private BenchmarkTestServer testServer;
    private HttpClient client;
    private String testUrl;
    private HttpRequest prebuiltGetRequest;
    private HttpRequest prebuiltPostNonStreamingRequest;
    private HttpRequest prebuiltPostStreamingRequest;

    @Setup(value=Level.Trial)
    public void setUp() throws Exception {
        this.testServer = new BenchmarkTestServer("localhost", this.serverPort.getNumber());
        this.testServer.addRequestHandler("/hello", (request, responseSender) -> {
            StringHttpEntity helloContent = new StringHttpEntity("Hello from benchmark server!");
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)helloContent), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.client = NettyHttpClient.builder().withConnectionIdleTimeout(1000).withUsingPersistentConnections(true).build();
        this.client.start();
        this.testUrl = String.format("http://localhost:%d/hello", this.serverPort.getNumber());
        this.buildRequests();
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        if (this.client != null) {
            this.client.stop();
        }
        if (this.testServer != null) {
            this.testServer.stop();
        }
    }

    @Issue(value="W-17282518")
    @Benchmark
    public void testHttpGetRequest(Blackhole blackhole) {
        try {
            HttpResponse response = (HttpResponse)this.client.sendAsync(this.prebuiltGetRequest).get();
            blackhole.consume(response.getStatusCode());
            blackhole.consume((Object)response.getEntity());
        }
        catch (Exception e) {
            throw new RuntimeException("Request execution failed", e);
        }
    }

    @Issue(value="W-17363023")
    @Benchmark
    public void testHttpPostWithNonStreamingRequest(Blackhole blackhole) {
        try {
            HttpResponse response = (HttpResponse)this.client.sendAsync(this.prebuiltPostNonStreamingRequest).get();
            blackhole.consume(response.getStatusCode());
            blackhole.consume((Object)response.getEntity());
        }
        catch (Exception e) {
            throw new RuntimeException("Request execution failed", e);
        }
    }

    @Issue(value="W-17363023")
    @Benchmark
    public void testHttpPostWithStreamingRequest(Blackhole blackhole) {
        try {
            HttpResponse response = (HttpResponse)this.client.sendAsync(this.prebuiltPostStreamingRequest).get();
            blackhole.consume(response.getStatusCode());
            blackhole.consume((Object)response.getEntity());
        }
        catch (Exception e) {
            throw new RuntimeException("Request execution failed", e);
        }
    }

    private void buildRequests() {
        this.prebuiltGetRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(this.testUrl).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        this.prebuiltPostNonStreamingRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(this.testUrl).method("POST").entity((HttpEntity)new StringHttpEntity("Hello from benchmarking client!"))).build();
        String message = "Hello from benchmarking client!";
        this.prebuiltPostStreamingRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(this.testUrl).method("POST").entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8))))).build();
    }
}

