/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarWithISODefaultNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class ToTemporalDateTimeNode
extends JavaScriptBaseNode {
    protected final JSContext ctx;

    protected ToTemporalDateTimeNode(JSContext context) {
        this.ctx = context;
    }

    public abstract JSTemporalPlainDateTimeObject execute(Object var1, JSDynamicObject var2);

    @Specialization
    public JSTemporalPlainDateTimeObject toTemporalDateTime(Object item, JSDynamicObject options, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isPlainDateTimeProfile, @Cached InlinedConditionProfile isZonedDateTimeProfile, @Cached InlinedConditionProfile isPlainDateProfile, @Cached InlinedBranchProfile errorBranch, @Cached IsObjectNode isObjectNode, @Cached JSToStringNode toStringNode, @Cached(value="create(ctx)") GetTemporalCalendarWithISODefaultNode getTemporalCalendarNode, @Cached(value="create(ctx)") ToTemporalCalendarWithISODefaultNode toTemporalCalendarWithISODefaultNode, @Cached(value="create(ctx)") TemporalCalendarFieldsNode calendarFieldsNode, @Cached TemporalGetOptionNode getOptionNode, @Cached(value="create(ctx)") TemporalCalendarDateFromFieldsNode dateFromFieldsNode) {
        assert (options != null);
        JSTemporalDateTimeRecord result = null;
        JSDynamicObject calendar = null;
        if (isObjectProfile.profile((Node)this, isObjectNode.executeBoolean(item))) {
            JSDynamicObject itemObj = (JSDynamicObject)((Object)item);
            if (isPlainDateTimeProfile.profile((Node)this, itemObj instanceof JSTemporalPlainDateTimeObject)) {
                return (JSTemporalPlainDateTimeObject)itemObj;
            }
            if (isZonedDateTimeProfile.profile((Node)this, TemporalUtil.isTemporalZonedDateTime((Object)itemObj))) {
                TemporalUtil.toTemporalOverflow(options, getOptionNode);
                JSTemporalZonedDateTimeObject zdt = (JSTemporalZonedDateTimeObject)itemObj;
                JSTemporalInstantObject instant = JSTemporalInstant.create(this.ctx, this.getRealm(), zdt.getNanoseconds());
                return TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.ctx, zdt.getTimeZone(), instant, zdt.getCalendar());
            }
            if (isPlainDateProfile.profile((Node)this, itemObj instanceof JSTemporalPlainDateObject)) {
                TemporalUtil.toTemporalOverflow(options, getOptionNode);
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)itemObj;
                return JSTemporalPlainDateTime.create(this.ctx, date.getYear(), date.getMonth(), date.getDay(), 0, 0, 0, 0, 0, 0, date.getCalendar(), this, errorBranch);
            }
            calendar = getTemporalCalendarNode.execute((Object)itemObj);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listDHMMMMMNSY);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.ctx, itemObj, fieldNames, TemporalUtil.listEmpty);
            result = TemporalUtil.interpretTemporalDateTimeFields(calendar, fields, options, getOptionNode, dateFromFieldsNode);
        } else {
            TemporalUtil.toTemporalOverflow(options, getOptionNode);
            TruffleString string = toStringNode.executeString(item);
            result = TemporalUtil.parseTemporalDateTimeString(string);
            assert (TemporalUtil.isValidISODate(result.getYear(), result.getMonth(), result.getDay()));
            assert (TemporalUtil.isValidTime(result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond()));
            calendar = toTemporalCalendarWithISODefaultNode.execute(result.getCalendar());
        }
        return JSTemporalPlainDateTime.create(this.ctx, result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), calendar, this, errorBranch);
    }
}

