/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.api.connection.PoolingListener;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connection.util.ConnectionProviderUtils;
import org.mule.runtime.core.internal.connection.CachedConnectionManagementStrategy;
import org.mule.runtime.core.internal.connection.ConnectionManagementStrategy;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.NullConnectionManagementStrategy;
import org.mule.runtime.core.internal.connection.PoolingConnectionManagementStrategy;

final class ConnectionManagementStrategyFactory {
    private final PoolingProfile defaultPoolingProfile;
    private final MuleContext muleContext;

    ConnectionManagementStrategyFactory(PoolingProfile defaultPoolingProfile, MuleContext muleContext) {
        this.defaultPoolingProfile = defaultPoolingProfile;
        this.muleContext = muleContext;
    }

    public <C> ConnectionManagementStrategy<C> getStrategy(ConnectionProvider<C> connectionProvider, FeatureFlaggingService featureFlaggingService) {
        ConnectionManagementType managementType = this.getManagementType(connectionProvider);
        if (managementType == ConnectionManagementType.POOLING) {
            return this.pooling(connectionProvider, featureFlaggingService);
        }
        if (managementType == ConnectionManagementType.CACHED) {
            return this.cached(connectionProvider);
        }
        if (managementType == ConnectionManagementType.NONE) {
            return this.withoutManagement(connectionProvider);
        }
        throw new IllegalArgumentException("Unknown management type: " + String.valueOf(managementType));
    }

    private <C> ConnectionManagementStrategy<C> cached(ConnectionProvider<C> connectionProvider) {
        return new CachedConnectionManagementStrategy<C>(connectionProvider, this.muleContext);
    }

    private <C> ConnectionManagementStrategy<C> withoutManagement(ConnectionProvider<C> connectionProvider) {
        return new NullConnectionManagementStrategy<C>(connectionProvider, this.muleContext);
    }

    private <C> ConnectionManagementStrategy<C> pooling(ConnectionProvider<C> connectionProvider, FeatureFlaggingService featureFlaggingService) {
        String ownerConfigName = "";
        PoolingProfile poolingProfile = this.defaultPoolingProfile;
        if (connectionProvider instanceof ConnectionProviderWrapper) {
            poolingProfile = ((ConnectionProviderWrapper)connectionProvider).getPoolingProfile().orElse(poolingProfile);
            ownerConfigName = ((ConnectionProviderWrapper)connectionProvider).getOwnerConfigName().orElse("");
        }
        return poolingProfile.isDisabled() ? this.withoutManagement(connectionProvider) : new PoolingConnectionManagementStrategy<C>(connectionProvider, poolingProfile, (PoolingListener)ConnectionProviderUtils.unwrapProviderWrapper(connectionProvider, PoolingConnectionProvider.class), this.muleContext, ownerConfigName, featureFlaggingService);
    }

    private <C> ConnectionManagementType getManagementType(ConnectionProvider<C> connectionProvider) {
        ConnectionManagementType type = ConnectionManagementType.NONE;
        if (connectionProvider instanceof ConnectionProviderWrapper) {
            return ((ConnectionProviderWrapper)connectionProvider).getConnectionManagementType();
        }
        if (connectionProvider instanceof PoolingConnectionProvider) {
            type = ConnectionManagementType.POOLING;
        } else if (connectionProvider instanceof CachedConnectionProvider) {
            type = ConnectionManagementType.CACHED;
        }
        return type;
    }
}

