/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.maven.pom.parser.api.MavenPomParserProvider;
import org.mule.maven.pom.parser.api.model.AdditionalPluginDependencies;
import org.mule.maven.pom.parser.api.model.PomParentCoordinates;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.globalconfig.api.maven.MavenClientFactory;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.internal.classloader.model.utils.ArtifactUtils;
import org.mule.runtime.module.artifact.activation.internal.deployable.AbstractDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.activation.internal.deployable.DeployablePluginsDependenciesResolver;
import org.mule.runtime.module.artifact.activation.internal.maven.AdditionalPluginDependenciesResolver;
import org.mule.runtime.module.artifact.activation.internal.maven.DeployableDependencyResolver;
import org.mule.runtime.module.artifact.activation.internal.maven.MavenDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.activation.internal.maven.MavenUtilsForArtifact;
import org.mule.runtime.module.artifact.activation.internal.maven.MuleSystemPluginMavenReactorResolver;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactConstants;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMavenDeployableProjectModelBuilder
extends AbstractDeployableProjectModelBuilder {
    protected static final String PACKAGE_TYPE = "jar";
    private static final MavenPomParserProvider POM_PARSER_PROVIDER = MavenPomParserProvider.discoverProvider();
    protected static final Supplier<MavenConfiguration> DEFAULT_MAVEN_CONFIGURATION = new LazyValue(AbstractMavenDeployableProjectModelBuilder::getDefaultMavenConfiguration);
    protected final MavenConfiguration mavenConfiguration;
    protected final File projectFolder;
    protected List<BundleDependency> deployableMavenBundleDependencies;
    protected List<BundleDependency> deployableBundleDependencies;
    protected Map<BundleDescriptor, List<BundleDependency>> pluginsArtifactDependencies;
    protected Set<BundleDescriptor> sharedDeployableBundleDescriptors;
    protected Map<BundleDescriptor, List<BundleDependency>> additionalPluginDependencies;
    protected Map<BundleDescriptor, List<BundleDependency>> pluginsBundleDependencies;
    protected File deployableArtifactRepositoryFolder;
    private static final Logger logger = LoggerFactory.getLogger(AbstractMavenDeployableProjectModelBuilder.class);
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{\\s*([^}]*)\\s*\\}");

    private static MavenConfiguration getDefaultMavenConfiguration() {
        MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)MavenDeployableProjectModelBuilder.class.getClassLoader());
        Supplier localMavenRepository = mavenClientProvider.getLocalRepositorySuppliers().environmentMavenRepositorySupplier();
        SettingsSupplierFactory settingsSupplierFactory = mavenClientProvider.getSettingsSupplierFactory();
        Optional globalSettings = settingsSupplierFactory.environmentGlobalSettingsSupplier();
        Optional userSettings = settingsSupplierFactory.environmentUserSettingsSupplier();
        Optional settingsSecurity = settingsSupplierFactory.environmentSettingsSecuritySupplier();
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().forcePolicyUpdateNever(true).localMavenRepositoryLocation((File)localMavenRepository.get());
        globalSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).globalSettingsLocation(arg_0));
        userSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).userSettingsLocation(arg_0));
        settingsSecurity.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).settingsSecurityLocation(arg_0));
        return mavenConfigurationBuilder.build();
    }

    protected AbstractMavenDeployableProjectModelBuilder(MavenConfiguration mavenConfiguration, File projectFolder) {
        this.mavenConfiguration = mavenConfiguration;
        this.projectFolder = projectFolder;
    }

    @Override
    public DeployableProjectModel build() {
        File pom = this.getPomFromFolder(this.projectFolder);
        Optional<String> version = Optional.empty();
        if (this.projectFolder.isDirectory()) {
            try {
                Properties pomProperties = MavenUtilsForArtifact.getPomPropertiesFolder(this.projectFolder);
                version = Optional.ofNullable(pomProperties.getProperty("version"));
            }
            catch (ArtifactDescriptorCreateException e) {
                logger.debug("unable to get version info from pom.properties:" + e.getMessage());
            }
        }
        List<String> activeProfiles = this.mavenConfiguration.getActiveProfiles().orElse(Collections.emptyList());
        MavenPomParser parser = POM_PARSER_PROVIDER.createMavenPomParserClient(pom.toPath(), activeProfiles);
        String originalPomVersion = this.getVersion(parser);
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(originalPomVersion);
        if (matcher.find()) {
            String potentialProperty = matcher.group(1);
            if (System.getProperty(potentialProperty) != null) {
                version = Optional.ofNullable(matcher.replaceAll(System.getProperty(potentialProperty)));
            } else if (parser.getProperties().containsKey(potentialProperty)) {
                version = Optional.ofNullable(matcher.replaceAll(parser.getProperties().getProperty(potentialProperty)));
            }
        }
        this.deployableArtifactRepositoryFolder = this.mavenConfiguration.getLocalMavenRepositoryLocation();
        ArtifactCoordinates deployableArtifactCoordinates = this.getDeployableProjectArtifactCoordinates(parser, version);
        try (MavenClient mavenClient = MavenClientFactory.createMavenClient((MavenConfiguration)this.mavenConfiguration);){
            this.resolveDeployableDependencies(mavenClient, pom, parser, activeProfiles);
            this.resolveDeployablePluginsData(this.deployableMavenBundleDependencies);
            this.resolveAdditionalPluginDependencies(mavenClient, parser, this.pluginsArtifactDependencies);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error while resolving dependencies"), (Throwable)e);
        }
        return this.doBuild(parser, deployableArtifactCoordinates);
    }

    protected abstract DeployableProjectModel doBuild(MavenPomParser var1, ArtifactCoordinates var2);

    protected abstract File getPomFromFolder(File var1);

    protected abstract boolean isIncludeTestDependencies();

    protected final List<String> getAttribute(Map<String, Object> attributes, String attribute) {
        if (attributes == null) {
            return Collections.emptyList();
        }
        List<String> attributeObject = attributes.getOrDefault(attribute, Collections.emptyList());
        Preconditions.checkArgument((boolean)(attributeObject instanceof List), (String)String.format("The '%s' attribute must be of '%s', found '%s'", attribute, List.class.getName(), attributeObject.getClass().getName()));
        return attributeObject;
    }

    protected final <T> T getSimpleAttribute(Map<String, Object> attributes, String attribute, T defaultValue) {
        return (T)attributes.getOrDefault(attribute, defaultValue);
    }

    protected BundleDescriptor buildBundleDescriptor(ArtifactCoordinates artifactCoordinates) {
        return new BundleDescriptor.Builder().setArtifactId(artifactCoordinates.getArtifactId()).setGroupId(artifactCoordinates.getGroupId()).setVersion(artifactCoordinates.getVersion()).setBaseVersion(artifactCoordinates.getVersion()).setType(PACKAGE_TYPE).setClassifier((String)artifactCoordinates.getClassifier().orElse(null)).build();
    }

    private String getGroupId(MavenPomParser parser) {
        String groupId = parser.getModel().getGroupId();
        if (groupId == null && (groupId = parser.getModel().getParent().map(PomParentCoordinates::getGroupId).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Failed to retrieve groupId from the artifact, trying to retrieve from parent POM but parent POM is not present")))) == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"GroupId is null in both current and parent POM"));
        }
        return groupId;
    }

    private String getArtifactId(MavenPomParser parser) {
        String artifactId = parser.getModel().getArtifactId();
        if (artifactId == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"ArtifactId is null in the POM"));
        }
        return artifactId;
    }

    private String getVersion(MavenPomParser parser) {
        String version = parser.getModel().getVersion();
        if (version == null && (version = parser.getModel().getParent().map(PomParentCoordinates::getVersion).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Failed to retrieve version from the artifact, trying to retrieve from parent POM but parent POM is not present")))) == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Version is null in both current and parent POM"));
        }
        return version;
    }

    private ArtifactCoordinates getDeployableProjectArtifactCoordinates(MavenPomParser parser, Optional<String> version) {
        return ArtifactUtils.getDeployableArtifactCoordinates(this.getGroupId(parser), this.getArtifactId(parser), version.orElse(this.getVersion(parser)), parser.getModel().getPackaging());
    }

    private void resolveDeployableDependencies(MavenClient mavenClient, File pom, MavenPomParser parser, List<String> activeProfiles) {
        DeployableDependencyResolver deployableDependencyResolver = new DeployableDependencyResolver(mavenClient);
        this.deployableMavenBundleDependencies = deployableDependencyResolver.resolveDeployableDependencies(pom, this.isIncludeTestDependencies(), this.getMavenReactorResolver());
        this.deployableMavenBundleDependencies = this.resolveSystemScopeDependencies(mavenClient, this.deployableMavenBundleDependencies);
        List<BundleDependency> deployableArtifactDependencies = ArtifactUtils.updatePackagesResources(ArtifactUtils.toApplicationModelArtifacts(this.deployableMavenBundleDependencies));
        List<BundleDependency> deployableArtifactSharedDependencies = ArtifactUtils.findArtifactsSharedDependencies(deployableArtifactDependencies, parser.getSharedLibraries().stream().map(sharedLibrary -> sharedLibrary.getGroupId() + ":" + sharedLibrary.getArtifactId()).collect(Collectors.toList()), activeProfiles);
        this.deployableBundleDependencies = deployableArtifactDependencies.stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((BundleDependency)artifact)).collect(Collectors.toList());
        this.sharedDeployableBundleDescriptors = this.deployableBundleDependencies.stream().filter(bd -> deployableArtifactSharedDependencies.stream().anyMatch(artifact -> bd.getDescriptor().getGroupId().equals(artifact.getDescriptor().getGroupId()) && bd.getDescriptor().getArtifactId().equals(artifact.getDescriptor().getArtifactId()))).map(BundleDependency::getDescriptor).collect(Collectors.toSet());
    }

    protected Optional<MavenReactorResolver> getMavenReactorResolver() {
        return Optional.empty();
    }

    private List<BundleDependency> resolveSystemScopeDependencies(MavenClient mavenClient, List<BundleDependency> deployableMavenBundleDependencies) {
        ArrayList systemScopeDependenciesTransitiveDependencies = new ArrayList();
        List<BundleDependency> result = deployableMavenBundleDependencies.stream().map(bundleDependency -> {
            if ("mule-plugin".equals(bundleDependency.getDescriptor().getClassifier().orElse(null)) && BundleScope.SYSTEM.equals((Object)bundleDependency.getScope())) {
                try (MuleSystemPluginMavenReactorResolver reactor = new MuleSystemPluginMavenReactorResolver(new File(bundleDependency.getBundleUri()), mavenClient);){
                    org.mule.maven.pom.parser.api.model.BundleDependency mvnBundleDependency = (org.mule.maven.pom.parser.api.model.BundleDependency)mavenClient.resolveArtifactDependencies(Collections.singletonList(MavenUtilsForArtifact.artifactToMaven(bundleDependency.getDescriptor())), Optional.of(this.deployableArtifactRepositoryFolder), Optional.of(reactor)).get(0);
                    BundleDependency systemScopeDependency = MavenUtilsForArtifact.mavenToArtifact(mvnBundleDependency);
                    systemScopeDependenciesTransitiveDependencies.addAll(this.collectTransitivePluginDependencies(systemScopeDependency));
                    BundleDependency bundleDependency2 = systemScopeDependency;
                    return bundleDependency2;
                }
            }
            return bundleDependency;
        }).collect(Collectors.toList());
        result.addAll(systemScopeDependenciesTransitiveDependencies);
        return this.getUniqueDependencies(result);
    }

    private List<BundleDependency> getUniqueDependencies(List<BundleDependency> dependencies) {
        HashSet uniqueDependenciesIds = new HashSet();
        return dependencies.stream().filter(dependency -> {
            BundleDescriptor descriptor = dependency.getDescriptor();
            String pluginKey = descriptor.getGroupId() + ":" + descriptor.getArtifactId() + ":" + descriptor.getVersion() + descriptor.getClassifier().map(classifier -> ":" + classifier).orElse("");
            boolean isApi = descriptor.getClassifier().map(ArtifactConstants.getApiClassifiers()::contains).orElse(false);
            boolean keep = !uniqueDependenciesIds.contains(pluginKey) || isApi;
            uniqueDependenciesIds.add(pluginKey);
            return keep;
        }).collect(Collectors.toList());
    }

    private List<BundleDependency> collectTransitivePluginDependencies(BundleDependency rootDependency) {
        ArrayList<BundleDependency> allTransitivePluginDependencies = new ArrayList<BundleDependency>();
        for (BundleDependency transitiveDependency : rootDependency.getTransitiveDependenciesList()) {
            if (!transitiveDependency.getDescriptor().getClassifier().map("mule-plugin"::equals).orElse(false).booleanValue()) continue;
            allTransitivePluginDependencies.add(transitiveDependency);
            allTransitivePluginDependencies.addAll(this.collectTransitivePluginDependencies(transitiveDependency));
        }
        return allTransitivePluginDependencies;
    }

    private void resolveAdditionalPluginDependencies(MavenClient mavenClient, MavenPomParser parser, Map<BundleDescriptor, List<BundleDependency>> pluginsDependencies) {
        Map initialAdditionalPluginDependencies = parser.getPomAdditionalPluginDependenciesForArtifacts();
        AdditionalPluginDependenciesResolver additionalPluginDependenciesResolver = this.getAdditionalPluginDependenciesResolver(mavenClient, new LinkedList<AdditionalPluginDependencies>(initialAdditionalPluginDependencies.values()));
        this.additionalPluginDependencies = this.toPluginDependencies(additionalPluginDependenciesResolver.resolveDependencies(this.deployableMavenBundleDependencies, pluginsDependencies));
    }

    protected AdditionalPluginDependenciesResolver getAdditionalPluginDependenciesResolver(MavenClient mavenClient, List<AdditionalPluginDependencies> initialAdditionalPluginDependencies) {
        return new AdditionalPluginDependenciesResolver(mavenClient, initialAdditionalPluginDependencies, new File("temp"));
    }

    private void resolveDeployablePluginsData(List<BundleDependency> deployableMavenBundleDependencies) {
        this.pluginsArtifactDependencies = new DeployablePluginsDependenciesResolver().resolve(deployableMavenBundleDependencies);
        HashMap pluginsBundleDescriptors = new HashMap();
        this.pluginsArtifactDependencies.keySet().forEach(pluginArtifactCoordinates -> pluginsBundleDescriptors.put(pluginArtifactCoordinates, this.buildBundleDescriptor((ArtifactCoordinates)pluginArtifactCoordinates)));
        this.pluginsBundleDependencies = new HashMap<BundleDescriptor, List<BundleDependency>>();
        this.pluginsArtifactDependencies.forEach((pluginArtifactCoordinates, pluginDependencies) -> this.pluginsBundleDependencies.put((BundleDescriptor)pluginsBundleDescriptors.get(pluginArtifactCoordinates), pluginDependencies.stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((BundleDependency)artifact)).collect(Collectors.toList())));
        this.deployableBundleDependencies = this.deployableBundleDependencies.stream().map(dbd -> BundleDependency.builder((BundleDependency)dbd).setTransitiveDependencies(this.pluginsBundleDependencies.get(dbd.getDescriptor())).build()).collect(Collectors.toList());
    }

    private Map<BundleDescriptor, List<BundleDependency>> toPluginDependencies(Map<BundleDependency, List<BundleDependency>> pluginsAndDependencies) {
        return pluginsAndDependencies.entrySet().stream().collect(Collectors.toMap(entry -> this.deployableBundleDependencies.stream().filter(bd -> bd.getDescriptor().getGroupId().equals(((BundleDependency)entry.getKey()).getDescriptor().getGroupId()) && bd.getDescriptor().getArtifactId().equals(((BundleDependency)entry.getKey()).getDescriptor().getArtifactId())).map(BundleDependency::getDescriptor).findAny().get(), entry -> {
            List<BundleDependency> deployableArtifactDependencies = ArtifactUtils.updatePackagesResources(ArtifactUtils.toApplicationModelArtifacts((List)entry.getValue()));
            return deployableArtifactDependencies.stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((BundleDependency)artifact)).collect(Collectors.toList());
        }));
    }

    private Function<BundleDependency, BundleDependency> createBundleDependencyFromPackagerDependency(Function<URI, URI> uriResolver) {
        return d -> {
            URI bundle = d.getBundleUri();
            if (!d.getBundleUri().isAbsolute()) {
                bundle = (URI)uriResolver.apply(d.getBundleUri());
            }
            return BundleDependency.builder().setDescriptor(d.getDescriptor()).setBundleUri(bundle).setPackages((Set)(d.getPackages() == null ? Collections.emptySet() : new HashSet(d.getPackages()))).setResources((Set)(d.getResources() == null ? Collections.emptySet() : new HashSet(d.getResources()))).setTransitiveDependencies(this.deployableBundleDependencies).build();
        };
    }

    private Function<URI, URI> getDeployableArtifactRepositoryUriResolver() {
        return uri -> new File(this.deployableArtifactRepositoryFolder, uri.toString()).toURI();
    }
}

