/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.charset.ClassSetContents;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Range;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.IntArrayBuffer;
import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import com.oracle.truffle.regex.tregex.parser.MultiCharacterCaseFolding;
import com.oracle.truffle.regex.tregex.parser.RegexASTBuilder;
import com.oracle.truffle.regex.tregex.parser.RegexParser;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTRootNode;
import com.oracle.truffle.regex.tregex.parser.flavors.OracleDBCharClassTrieNode;
import com.oracle.truffle.regex.tregex.parser.flavors.OracleDBConstants;
import com.oracle.truffle.regex.tregex.parser.flavors.OracleDBFlags;
import com.oracle.truffle.regex.tregex.parser.flavors.OracleDBRegexLexer;
import com.oracle.truffle.regex.tregex.string.Encodings;

public final class OracleDBRegexParser
implements RegexParser {
    private static final CodePointSet UPPER_CASE = (CodePointSet)OracleDBConstants.POSIX_CHAR_CLASSES.get((Object)"upper");
    private final RegexSource source;
    private final OracleDBFlags flags;
    private final OracleDBRegexLexer lexer;
    private final RegexASTBuilder astBuilder;
    private final OracleDBCharClassTrieNode curCharClass = OracleDBCharClassTrieNode.createTreeRoot();
    private final CodePointSetAccumulator charClassTmpCaseClosure = new CodePointSetAccumulator();
    private final CodePointSetAccumulator charClassTmp2 = new CodePointSetAccumulator();

    @CompilerDirectives.TruffleBoundary
    public OracleDBRegexParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) throws RegexSyntaxException {
        this(language, source, compilationBuffer, source);
    }

    public OracleDBRegexParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer, RegexSource originalSource) throws RegexSyntaxException {
        this.source = source;
        this.flags = OracleDBFlags.parseFlags(source);
        this.lexer = new OracleDBRegexLexer(source, this.flags, compilationBuffer);
        this.astBuilder = new RegexASTBuilder(language, originalSource, RegexFlags.builder().dotAll(this.flags.isDotAll()).ignoreCase(this.flags.isIgnoreCase()).multiline(this.flags.isMultiline()).build(), false, compilationBuffer);
    }

    @Override
    public OracleDBFlags getFlags() {
        return this.flags;
    }

    @Override
    public AbstractRegexObject getNamedCaptureGroups() {
        return AbstractRegexObject.createNamedCaptureGroupMapInt(this.lexer.getNamedCaptureGroups());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public RegexAST parse() throws RegexSyntaxException {
        IntArrayBuffer literalStringBuffer = new IntArrayBuffer();
        this.astBuilder.pushRootGroup();
        Token token = null;
        block15: while (this.lexer.hasNext()) {
            Token.Kind prevKind = token == null ? null : token.kind;
            token = this.lexer.next();
            if (token.kind != Token.Kind.literalChar && !literalStringBuffer.isEmpty()) {
                int last = -1;
                if (token.kind == Token.Kind.quantifier) {
                    last = literalStringBuffer.removeLast();
                }
                this.addLiteralString(literalStringBuffer);
                if (last >= 0) {
                    assert (literalStringBuffer.isEmpty());
                    literalStringBuffer.add(last);
                    this.addLiteralString(literalStringBuffer);
                }
            }
            switch (token.kind) {
                case A: 
                case z: {
                    this.astBuilder.addPositionAssertion(token);
                    continue block15;
                }
                case caret: {
                    if (this.flags.isMultiline()) {
                        this.astBuilder.pushGroup();
                        this.astBuilder.addCaret();
                        this.astBuilder.nextSequence();
                        this.astBuilder.pushLookBehindAssertion(false);
                        this.astBuilder.addCharClass(CodePointSet.create(10));
                        this.astBuilder.popGroup();
                        this.astBuilder.popGroup();
                        continue block15;
                    }
                    this.astBuilder.addPositionAssertion(token);
                    continue block15;
                }
                case dollar: 
                case Z: {
                    this.astBuilder.pushGroup();
                    this.astBuilder.addDollar();
                    this.astBuilder.nextSequence();
                    this.astBuilder.pushLookAheadAssertion(false);
                    this.astBuilder.addCharClass(CodePointSet.create(10));
                    if (token.kind == Token.Kind.Z || !this.flags.isMultiline()) {
                        this.astBuilder.addDollar();
                    }
                    this.astBuilder.popGroup();
                    this.astBuilder.popGroup();
                    continue block15;
                }
                case backReference: {
                    this.astBuilder.addBackReference((Token.BackReference)token, this.flags.isIgnoreCase());
                    continue block15;
                }
                case quantifier: {
                    if (this.astBuilder.getCurTerm() == null || prevKind == Token.Kind.captureGroupBegin) continue block15;
                    this.astBuilder.addQuantifier((Token.Quantifier)token);
                    continue block15;
                }
                case alternation: {
                    this.astBuilder.nextSequence();
                    continue block15;
                }
                case captureGroupBegin: {
                    if (this.lexer.numberOfCaptureGroupsSoFar() <= 10) {
                        this.astBuilder.pushCaptureGroup(token);
                        continue block15;
                    }
                    this.astBuilder.pushGroup(token);
                    continue block15;
                }
                case groupEnd: {
                    if (this.astBuilder.getCurGroup().getParent() instanceof RegexASTRootNode) {
                        throw this.syntaxError("unmatched parentheses in regular expression");
                    }
                    this.astBuilder.popGroup(token);
                    continue block15;
                }
                case literalChar: {
                    literalStringBuffer.add(((Token.LiteralCharacter)token).getCodePoint());
                    continue block15;
                }
                case charClass: {
                    this.astBuilder.addCharClass((Token.CharacterClass)token);
                    continue block15;
                }
                case charClassBegin: {
                    this.curCharClass.clear();
                    continue block15;
                }
                case charClassAtom: {
                    ClassSetContents contents = ((Token.CharacterClassAtom)token).getContents();
                    if (this.flags.isIgnoreCase()) {
                        this.addCCAtomIgnoreCase(contents);
                        continue block15;
                    }
                    this.addCCAtom(contents);
                    continue block15;
                }
                case charClassEnd: {
                    this.addCharClass(token);
                    continue block15;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (!this.astBuilder.curGroupIsRoot()) {
            throw this.syntaxError("unmatched parentheses in regular expression");
        }
        if (!literalStringBuffer.isEmpty()) {
            this.addLiteralString(literalStringBuffer);
        }
        return this.astBuilder.popRootGroup();
    }

    private void addCCAtom(ClassSetContents contents) {
        if (contents.isPosixCollationEquivalenceClass()) {
            this.addCCAtomMultiCharExpansion(contents, CaseFoldData.CaseFoldAlgorithm.OracleDBAI);
        } else {
            this.addCCAtomCodePointSet(contents.getCodePointSet());
        }
    }

    private void addCCAtomCodePointSet(CodePointSet codePointSet) {
        if (!codePointSet.isEmpty()) {
            for (OracleDBCharClassTrieNode child : this.curCharClass.getOrAddChildren(codePointSet, true, this.lexer.getCompilationBuffer())) {
                child.setEndOfString();
            }
        }
    }

    private void addCCAtomIgnoreCase(ClassSetContents contents) {
        if (contents.isPosixCollationEquivalenceClass()) {
            this.addCCAtomMultiCharExpansion(contents, CaseFoldData.CaseFoldAlgorithm.OracleDBAI);
        } else if (contents.isRange()) {
            CodePointSet range = this.ccAtomRangeIgnoreCase(contents.getCodePointSet());
            this.charClassTmpCaseClosure.clear();
            this.charClassTmpCaseClosure.addSet(range);
            CaseFoldData.applyCaseFoldUnfold(this.charClassTmpCaseClosure, this.charClassTmp2, CaseFoldData.CaseFoldUnfoldAlgorithm.OracleDBSimple);
            this.addCCAtomCodePointSet(this.charClassTmpCaseClosure.toCodePointSet());
        } else if (contents.isCharacterClass()) {
            this.addCCAtomCodePointSet(contents.getCodePointSet());
        } else {
            assert (contents.isCharacter() || contents.isPosixCollationElement());
            this.addCCAtomMultiCharExpansion(contents, CaseFoldData.CaseFoldAlgorithm.OracleDB);
        }
    }

    private void addCCAtomMultiCharExpansion(ClassSetContents contents, CaseFoldData.CaseFoldAlgorithm algorithm) {
        this.caseClosure(algorithm, contents.getCodePointSet());
        this.addCCAtomCodePointSet(this.charClassTmpCaseClosure.toCodePointSet());
        assert (contents.isCharacter() || contents.isPosixCollationElement() || contents.isPosixCollationEquivalenceClass());
        assert (contents.getCodePointSet().matchesSingleChar());
        CaseFoldData.getTable(algorithm).caseFold(contents.getCodePointSet().iterator().next(), (codepoint, caseFolded) -> {
            if (((int[])caseFolded).length > 1) {
                CodePointSet encodingRange = Encodings.UTF_8.getFullSet();
                CompilationBuffer compilationBuffer = this.lexer.getCompilationBuffer();
                MultiCharacterCaseFolding.caseFoldUnfoldString(algorithm, caseFolded, encodingRange, false, false, null, this.curCharClass, compilationBuffer);
            }
        });
    }

    private void caseClosure(CaseFoldData.CaseFoldAlgorithm algorithm, CodePointSet codePointSet) {
        this.charClassTmpCaseClosure.clear();
        this.charClassTmpCaseClosure.addSet(codePointSet);
        MultiCharacterCaseFolding.caseClosure(algorithm, this.charClassTmpCaseClosure, this.charClassTmp2, (a, b) -> true, Encodings.UTF_8.getFullSet(), false);
    }

    private CodePointSet ccAtomRangeIgnoreCase(CodePointSet range) {
        assert (range.size() == 1);
        assert (this.flags.isIgnoreCase());
        int lo = range.getMin();
        int hi = range.getMax();
        CaseFoldData.CaseFoldTable caseFoldTable = CaseFoldData.getTable(CaseFoldData.CaseFoldAlgorithm.OracleDBSimple);
        int loLC = OracleDBRegexParser.caseFoldSingle(caseFoldTable, lo);
        int hiLC = OracleDBRegexParser.caseFoldSingle(caseFoldTable, hi);
        int rangeLo = Math.min(loLC, hiLC);
        int rangeHi = Math.max(loLC, hiLC);
        CodePointSetAccumulator toRemove = new CodePointSetAccumulator();
        if (UPPER_CASE.contains(lo) != UPPER_CASE.contains(hi)) {
            if (loLC <= hiLC || hiLC == loLC - 1) {
                return Encodings.UTF_8.getFullSet();
            }
            CodePointSet ret = CodePointSet.create(0, hiLC, loLC, 0x10FFFF);
            for (Range r : ret) {
                caseFoldTable.caseFold(r, (codePoint, caseFolded) -> {
                    if (loLC > caseFolded[0] && caseFolded[0] > hiLC) {
                        toRemove.addCodePoint((int)codePoint);
                    }
                });
            }
            return ret.subtract(toRemove.toCodePointSet());
        }
        caseFoldTable.caseFold(new Range(rangeLo, rangeHi), (codePoint, caseFolded) -> {
            if (caseFolded[0] < loLC || caseFolded[0] > hiLC) {
                toRemove.addCodePoint((int)codePoint);
            }
        });
        return CodePointSet.create(rangeLo, rangeHi).subtract(toRemove.toCodePointSet());
    }

    private static int caseFoldSingle(CaseFoldData.CaseFoldTable caseFoldTable, int codepoint) {
        int[] caseFolded = caseFoldTable.caseFold(codepoint);
        return caseFolded == null ? codepoint : caseFolded[0];
    }

    private void addCharClass(Token ccEnd) {
        this.astBuilder.setOverrideSourceSection(ccEnd.getSourceSection());
        this.curCharClass.generateAST(this.astBuilder, this.lexer.isCurCharClassInverted());
        this.astBuilder.clearOverrideSourceSection();
    }

    private void addLiteralString(IntArrayBuffer literalStringBuffer) {
        if (this.flags.isIgnoreCase()) {
            int[] codepoints = literalStringBuffer.toArray();
            CodePointSet encodingRange = Encodings.UTF_8.getFullSet();
            CompilationBuffer compilationBuffer = this.lexer.getCompilationBuffer();
            MultiCharacterCaseFolding.caseFoldUnfoldString(CaseFoldData.CaseFoldAlgorithm.OracleDB, codepoints, encodingRange, false, false, this.astBuilder, null, compilationBuffer);
        } else {
            for (int i = 0; i < literalStringBuffer.length(); ++i) {
                this.astBuilder.addCharClass(CodePointSet.create(literalStringBuffer.get(i)), true);
            }
        }
        literalStringBuffer.clear();
    }

    private RegexSyntaxException syntaxError(String msg) {
        return RegexSyntaxException.createPattern(this.source, msg, this.lexer.getLastTokenPosition());
    }
}

