/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.internal.streaming.CursorProviderJanitor;
import org.mule.runtime.core.internal.streaming.bytes.ManagedCursorStreamProvider;

class ManagedCursorStreamDecorator
extends CursorStream {
    private ManagedCursorStreamProvider managedCursorProvider;
    private CursorStreamProvider exposedProvider;
    private final CursorStream delegate;
    private final CursorProviderJanitor janitor;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    ManagedCursorStreamDecorator(ManagedCursorStreamProvider managedCursorProvider, CursorStream delegate, CursorProviderJanitor janitor) {
        this.managedCursorProvider = managedCursorProvider;
        this.exposedProvider = managedCursorProvider;
        this.delegate = delegate;
        this.janitor = janitor;
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.delegate.close();
            }
            finally {
                if (this.managedCursorProvider != null) {
                    this.exposedProvider = (CursorStreamProvider)this.managedCursorProvider.getDelegate();
                    this.managedCursorProvider = null;
                }
                this.janitor.releaseCursor((Cursor)this.delegate);
            }
        }
    }

    public long getPosition() {
        return this.delegate.getPosition();
    }

    public void seek(long position) throws IOException {
        this.delegate.seek(position);
    }

    public boolean isReleased() {
        return this.delegate.isReleased();
    }

    public void release() {
        this.delegate.release();
    }

    public CursorProvider getProvider() {
        return this.exposedProvider;
    }

    public int read() throws IOException {
        return this.delegate.read();
    }

    public int read(byte[] b) throws IOException {
        return this.delegate.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    public int available() throws IOException {
        return this.delegate.available();
    }

    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    public void reset() throws IOException {
        this.delegate.reset();
    }

    public boolean markSupported() {
        return this.delegate.markSupported();
    }
}

