/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.util;

import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mule.service.http.netty.impl.streaming.BlockingBidirectionalStream;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.PollingProber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Story(value="Streaming")
public class BlockingBufferTestCase
extends AbstractMuleTestCase {
    private static final String TEST_PAYLOAD = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockingBufferTestCase.class);
    private final BlockingBidirectionalStream blockingBuffer = new BlockingBidirectionalStream();
    private TestConsumer consumer;

    private void startConsumer() {
        this.consumer = new TestConsumer(this.blockingBuffer.getInputStream(), 8);
        this.consumer.start();
    }

    @After
    public void tearDown() throws InterruptedException {
        if (this.consumer != null) {
            this.consumer.join();
        }
    }

    @Test
    @Issue(value="W-19584546")
    public void readShouldReturnValuesBetween_0_and_255() throws Exception {
        BlockingBidirectionalStream bidiStream = new BlockingBidirectionalStream();
        bidiStream.write(new byte[]{-117, -117}, 0, 2);
        bidiStream.close();
        MatcherAssert.assertThat((Object)bidiStream.read(), (Matcher)Matchers.is((Object)139));
        MatcherAssert.assertThat((Object)bidiStream.read(), (Matcher)Matchers.is((Object)139));
        MatcherAssert.assertThat((Object)bidiStream.read(), (Matcher)Matchers.is((Object)-1));
    }

    @Test
    public void consumerBlocksWhenBufferIsEmpty() throws InterruptedException {
        this.startConsumer();
        Thread.sleep(500L);
        MatcherAssert.assertThat((Object)this.consumer.finishedReading(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.consumer.getConsumedData().length, (Matcher)Matchers.is((Object)0));
        this.consumer.interrupt();
        PollingProber.probe(() -> {
            Exception error = this.consumer.getErrorWhileConsuming();
            MatcherAssert.assertThat((Object)error, (Matcher)Matchers.instanceOf(IOException.class));
            MatcherAssert.assertThat((Object)error.getCause(), (Matcher)Matchers.instanceOf(InterruptedException.class));
            return true;
        });
    }

    @Test
    public void consumerUnblocksWhenBufferIsClosedAndEmpty() throws InterruptedException, IOException {
        this.startConsumer();
        Thread.sleep(500L);
        MatcherAssert.assertThat((Object)this.consumer.finishedReading(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.consumer.getConsumedData().length, (Matcher)Matchers.is((Object)0));
        this.blockingBuffer.getOutputStream().close();
        PollingProber.probe(() -> {
            MatcherAssert.assertThat((Object)this.consumer.finishedReading(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)this.consumer.getErrorWhileConsuming(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)this.consumer.getConsumedData().length, (Matcher)Matchers.is((Object)0));
            return true;
        });
    }

    @Test
    public void cancellationErrorIsPropagatedToReader() {
        this.startConsumer();
        MatcherAssert.assertThat((Object)this.consumer.finishedReading(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.consumer.getConsumedData().length, (Matcher)Matchers.is((Object)0));
        RuntimeException cancellationException = new RuntimeException("Expected!!");
        this.blockingBuffer.getOutputStream().cancel((Throwable)cancellationException);
        PollingProber.probe(() -> {
            MatcherAssert.assertThat((Object)this.consumer.finishedReading(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)this.consumer.getConsumedData().length, (Matcher)Matchers.is((Object)0));
            MatcherAssert.assertThat((Object)this.consumer.getErrorWhileConsuming(), (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(IOException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.is((Object)"Streaming canceled by writer")), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)Matchers.is((Object)cancellationException))));
            return true;
        });
    }

    @Test
    public void cancellationErrorPushesBackTheNextWrite() {
        this.startConsumer();
        MatcherAssert.assertThat((Object)this.consumer.finishedReading(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.consumer.getConsumedData().length, (Matcher)Matchers.is((Object)0));
        RuntimeException cancellationException = new RuntimeException("Expected!!");
        this.blockingBuffer.getOutputStream().cancel((Throwable)cancellationException);
        IOException error = (IOException)Assert.assertThrows(IOException.class, () -> this.blockingBuffer.getOutputStream().write(TEST_PAYLOAD.getBytes(StandardCharsets.UTF_8)));
        MatcherAssert.assertThat((Object)error, (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(IOException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.is((Object)"Trying to write in a canceled stream")), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)Matchers.is((Object)cancellationException))));
    }

    @Test
    public void writeAndReadAPayloadWithDifferentChunkSizes() throws IOException {
        String[] words;
        this.startConsumer();
        for (String word : words = TEST_PAYLOAD.split(" ")) {
            this.blockingBuffer.getOutputStream().write(word.getBytes(StandardCharsets.UTF_8));
        }
        this.blockingBuffer.getOutputStream().close();
        String testPayloadWithoutSpaces = TEST_PAYLOAD.replace(" ", "");
        PollingProber.probe(() -> {
            MatcherAssert.assertThat((Object)new String(this.consumer.getConsumedData()), (Matcher)Matchers.is((Object)testPayloadWithoutSpaces));
            MatcherAssert.assertThat((Object)this.consumer.finishedReading(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)this.consumer.getErrorWhileConsuming(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            return true;
        });
    }

    @Test
    public void writeBytePerByte() throws IOException {
        this.startConsumer();
        for (byte b : TEST_PAYLOAD.getBytes(StandardCharsets.UTF_8)) {
            this.blockingBuffer.getOutputStream().write((int)b);
        }
        this.blockingBuffer.getOutputStream().close();
        PollingProber.probe(() -> {
            MatcherAssert.assertThat((Object)new String(this.consumer.getConsumedData()), (Matcher)Matchers.is((Object)TEST_PAYLOAD));
            MatcherAssert.assertThat((Object)this.consumer.finishedReading(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)this.consumer.getErrorWhileConsuming(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            return true;
        });
    }

    @Test
    public void writeLessBytesThanBufferSize() throws IOException {
        this.startConsumer();
        byte[] abc = "abc".getBytes(StandardCharsets.UTF_8);
        this.blockingBuffer.getOutputStream().write(abc);
        PollingProber.probe(() -> {
            MatcherAssert.assertThat((Object)new String(this.consumer.getConsumedData()), (Matcher)Matchers.is((Object)"abc"));
            MatcherAssert.assertThat((Object)this.consumer.finishedReading(), (Matcher)Matchers.is((Object)false));
            return true;
        });
        this.blockingBuffer.getOutputStream().close();
        PollingProber.probe(() -> {
            MatcherAssert.assertThat((Object)this.consumer.finishedReading(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)this.consumer.getErrorWhileConsuming(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            return true;
        });
    }

    private static class TestConsumer
    extends Thread {
        private final InputStream inputStream;
        private final int consumerBufferSize;
        private final ByteArrayOutputStream consumedData;
        private final AtomicBoolean continueReading;
        private Exception errorWhileConsuming;

        public TestConsumer(InputStream inputStream, int consumerBufferSize) {
            this.inputStream = inputStream;
            this.consumerBufferSize = consumerBufferSize;
            this.consumedData = new ByteArrayOutputStream();
            this.continueReading = new AtomicBoolean(true);
        }

        public synchronized byte[] getConsumedData() {
            return this.consumedData.toByteArray();
        }

        public boolean finishedReading() {
            return !this.continueReading.get();
        }

        public Exception getErrorWhileConsuming() {
            return this.errorWhileConsuming;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.continueReading.get()) {
                byte[] consumerBuffer = new byte[this.consumerBufferSize];
                try {
                    int bytesRead = this.inputStream.read(consumerBuffer, 0, this.consumerBufferSize);
                    if (bytesRead == -1 || bytesRead == 0) {
                        this.continueReading.set(false);
                        continue;
                    }
                    TestConsumer testConsumer = this;
                    synchronized (testConsumer) {
                        LOGGER.debug("Reading this chunk [{}]", (Object)new String(consumerBuffer, 0, bytesRead));
                        this.consumedData.write(consumerBuffer, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    LOGGER.debug("Found error while consuming", (Throwable)e);
                    this.errorWhileConsuming = e;
                    this.continueReading.set(false);
                }
            }
        }
    }
}

