/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsl.syntax;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

public final class DslElementSyntaxBuilder {
    private String attributeName = "";
    private String elementName = "";
    private String prefix = "";
    private String namespace = "";
    private boolean isWrapped = false;
    private boolean supportsAttributeDeclaration = true;
    private boolean supportsChildDeclaration = false;
    private boolean supportsTopLevelDeclaration = false;
    private boolean requiresConfig = false;
    private final Map<MetadataType, DslElementSyntax> genericChilds = new HashMap<MetadataType, DslElementSyntax>();
    private final Map<String, DslElementSyntax> containedElements = new LinkedHashMap<String, DslElementSyntax>();

    private DslElementSyntaxBuilder() {
    }

    public static DslElementSyntaxBuilder create() {
        return new DslElementSyntaxBuilder();
    }

    public DslElementSyntaxBuilder withAttributeName(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    public DslElementSyntaxBuilder withElementName(String elementName) {
        this.elementName = elementName;
        return this;
    }

    public DslElementSyntaxBuilder withNamespace(String prefix, String namespace) {
        this.prefix = prefix;
        this.namespace = namespace;
        return this;
    }

    public DslElementSyntaxBuilder asWrappedElement(boolean isWrapped) {
        this.isWrapped = isWrapped;
        return this;
    }

    public DslElementSyntaxBuilder supportsAttributeDeclaration(boolean supportsAttribute) {
        this.supportsAttributeDeclaration = supportsAttribute;
        return this;
    }

    public DslElementSyntaxBuilder supportsChildDeclaration(boolean supportsChild) {
        this.supportsChildDeclaration = supportsChild;
        return this;
    }

    public DslElementSyntaxBuilder supportsTopLevelDeclaration(boolean supportsTop) {
        this.supportsTopLevelDeclaration = supportsTop;
        return this;
    }

    public DslElementSyntaxBuilder requiresConfig(boolean requiresConfig) {
        this.requiresConfig = requiresConfig;
        return this;
    }

    public DslElementSyntaxBuilder withGeneric(MetadataType type, DslElementSyntax child) {
        if (child == null) {
            throw new IllegalArgumentException("Invalid child declaration, child element should not be null");
        }
        this.genericChilds.put(type, child);
        return this;
    }

    public DslElementSyntaxBuilder containing(String name, DslElementSyntax child) {
        if (child == null) {
            throw new IllegalArgumentException("Invalid child declaration, child element should not be null");
        }
        this.containedElements.put(name, child);
        return this;
    }

    public DslElementSyntax build() {
        return new DslElementSyntax(this.attributeName, this.elementName, this.prefix, this.namespace, this.isWrapped, this.supportsAttributeDeclaration, this.supportsChildDeclaration, this.supportsTopLevelDeclaration, this.requiresConfig, this.genericChilds, this.containedElements);
    }
}

