/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.message;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.netty.impl.message.content.StreamedMultipartHttpEntity;
import reactor.netty.http.client.HttpClientResponse;

public class HttpResponseCreator {
    private static final String HEADER_CONTENT_TYPE = "Content-Type".toLowerCase();
    private static final String HEADER_CONTENT_LENGTH = "Content-Length".toLowerCase();

    public org.mule.runtime.http.api.domain.message.response.HttpResponse create(HttpResponse response, InputStream inputStream) throws IOException {
        HttpResponseBuilder responseBuilder = org.mule.runtime.http.api.domain.message.response.HttpResponse.builder().statusCode(Integer.valueOf(response.status().code())).reasonPhrase(response.status().reasonPhrase());
        String contentType = null;
        String contentLength = null;
        HttpHeaders headers = response.headers();
        if (!headers.isEmpty()) {
            for (String headerName : headers.names()) {
                responseBuilder.addHeaders(headerName, (Collection)response.headers().getAll(headerName));
                if (headerName.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                    contentType = response.headers().get(HEADER_CONTENT_TYPE);
                    continue;
                }
                if (!headerName.equalsIgnoreCase(HEADER_CONTENT_LENGTH)) continue;
                contentLength = response.headers().get(HEADER_CONTENT_LENGTH);
            }
        }
        responseBuilder.entity(this.createEntity(inputStream, contentType, contentLength, response.status().code()));
        return responseBuilder.build();
    }

    public org.mule.runtime.http.api.domain.message.response.HttpResponse create(HttpClientResponse response, InputStream inputStream) {
        HttpResponseBuilder responseBuilder = org.mule.runtime.http.api.domain.message.response.HttpResponse.builder().statusCode(Integer.valueOf(response.status().code())).reasonPhrase(response.status().reasonPhrase());
        String contentType = null;
        String contentLength = null;
        HttpHeaders headers = response.responseHeaders();
        if (!headers.isEmpty()) {
            for (String headerName : headers.names()) {
                responseBuilder.addHeaders(headerName, (Collection)response.responseHeaders().getAll(headerName));
                if (headerName.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                    contentType = response.responseHeaders().get(HEADER_CONTENT_TYPE);
                    continue;
                }
                if (!headerName.equalsIgnoreCase(HEADER_CONTENT_LENGTH)) continue;
                contentLength = response.responseHeaders().get(HEADER_CONTENT_LENGTH);
            }
        }
        responseBuilder.entity(this.createEntity(inputStream, contentType, contentLength, response.status().code()));
        return responseBuilder.build();
    }

    private HttpEntity createEntity(InputStream stream, String contentType, String contentLength, int statusCode) {
        long contentLengthAsLong = -1L;
        if (contentLength != null) {
            contentLengthAsLong = Long.parseLong(contentLength);
        }
        if (contentType != null && contentType.startsWith(MediaType.MULTIPART_MIXED.getPrimaryType())) {
            if (contentLengthAsLong >= 0L) {
                return new StreamedMultipartHttpEntity(stream, contentType, contentLengthAsLong);
            }
            return new StreamedMultipartHttpEntity(stream, contentType);
        }
        if (contentLengthAsLong > 0L) {
            return new InputStreamHttpEntity(stream, contentLengthAsLong);
        }
        if (contentLengthAsLong == 0L) {
            return new EmptyHttpEntity();
        }
        if (statusCode == HttpConstants.HttpStatus.NO_CONTENT.getStatusCode() || statusCode == HttpConstants.HttpStatus.NOT_MODIFIED.getStatusCode() || statusCode == HttpConstants.HttpStatus.RESET_CONTENT.getStatusCode()) {
            return new EmptyHttpEntity();
        }
        return new InputStreamHttpEntity(stream);
    }
}

