/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.Collections;
import java.util.List;

public final class InetNoopAddressResolverGroup
extends AddressResolverGroup<InetSocketAddress> {
    public static final InetNoopAddressResolverGroup INSTANCE = new InetNoopAddressResolverGroup();

    private InetNoopAddressResolverGroup() {
    }

    protected AddressResolver<InetSocketAddress> newResolver(final EventExecutor executor) throws Exception {
        return new AddressResolver<InetSocketAddress>(){

            public boolean isSupported(SocketAddress address) {
                return address instanceof InetSocketAddress;
            }

            public boolean isResolved(SocketAddress address) {
                return address instanceof InetSocketAddress;
            }

            public Future<InetSocketAddress> resolve(SocketAddress address) {
                if (address instanceof InetSocketAddress) {
                    return executor.newSucceededFuture((Object)((InetSocketAddress)address));
                }
                return executor.newFailedFuture((Throwable)new UnsupportedAddressTypeException());
            }

            public Future<InetSocketAddress> resolve(SocketAddress address, Promise<InetSocketAddress> promise) {
                if (address instanceof InetSocketAddress) {
                    promise.setSuccess((Object)((InetSocketAddress)address));
                } else {
                    promise.setFailure((Throwable)new UnsupportedAddressTypeException());
                }
                return promise;
            }

            public Future<List<InetSocketAddress>> resolveAll(SocketAddress address) {
                if (address instanceof InetSocketAddress) {
                    return executor.newSucceededFuture(Collections.singletonList((InetSocketAddress)address));
                }
                return executor.newFailedFuture((Throwable)new UnsupportedAddressTypeException());
            }

            public Future<List<InetSocketAddress>> resolveAll(SocketAddress address, Promise<List<InetSocketAddress>> promise) {
                if (address instanceof InetSocketAddress) {
                    promise.setSuccess(Collections.singletonList((InetSocketAddress)address));
                } else {
                    promise.setFailure((Throwable)new UnsupportedAddressTypeException());
                }
                return promise;
            }

            public void close() {
            }
        };
    }
}

