/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.memory;

import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.memory.SimpleByteArraySupportLock;

final class SimpleByteArraySupport
extends ByteArraySupport {
    private final SimpleByteArraySupportLock lock = new SimpleByteArraySupportLock();

    SimpleByteArraySupport() {
    }

    @Override
    public byte getByte(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return buffer[byteOffset];
    }

    @Override
    public byte getByte(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        assert (byteOffset < Integer.MAX_VALUE);
        return this.getByte(buffer, (int)byteOffset);
    }

    @Override
    public void putByte(byte[] buffer, int byteOffset, byte value) throws IndexOutOfBoundsException {
        buffer[byteOffset] = value;
    }

    @Override
    public void putByte(byte[] buffer, long byteOffset, byte value) throws IndexOutOfBoundsException {
        assert (byteOffset < Integer.MAX_VALUE);
        this.putByte(buffer, (int)byteOffset, value);
    }

    @Override
    public short getShort(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return (short)((buffer[byteOffset] & 0xFF) << 8 | buffer[byteOffset + 1] & 0xFF);
    }

    @Override
    public short getShort(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        assert (byteOffset < Integer.MAX_VALUE);
        return this.getShort(buffer, (int)byteOffset);
    }

    @Override
    public void putShort(byte[] buffer, int byteOffset, short value) throws IndexOutOfBoundsException {
        buffer[byteOffset + 0] = (byte)(value >> 8);
        buffer[byteOffset + 1] = (byte)value;
    }

    @Override
    public void putShort(byte[] buffer, long byteOffset, short value) throws IndexOutOfBoundsException {
        assert (byteOffset < Integer.MAX_VALUE);
        this.putShort(buffer, (int)byteOffset, value);
    }

    @Override
    public int getInt(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return (buffer[byteOffset + 0] & 0xFF) << 24 | (buffer[byteOffset + 1] & 0xFF) << 16 | (buffer[byteOffset + 2] & 0xFF) << 8 | buffer[byteOffset + 3] & 0xFF;
    }

    @Override
    public int getInt(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        assert (byteOffset < Integer.MAX_VALUE);
        return this.getInt(buffer, (int)byteOffset);
    }

    @Override
    public void putInt(byte[] buffer, int byteOffset, int value) throws IndexOutOfBoundsException {
        buffer[byteOffset + 0] = (byte)(value >> 24);
        buffer[byteOffset + 1] = (byte)(value >> 16);
        buffer[byteOffset + 2] = (byte)(value >> 8);
        buffer[byteOffset + 3] = (byte)value;
    }

    @Override
    public void putInt(byte[] buffer, long byteOffset, int value) throws IndexOutOfBoundsException {
        assert (byteOffset < Integer.MAX_VALUE);
        this.putInt(buffer, (int)byteOffset, value);
    }

    @Override
    public long getLong(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return ((long)buffer[byteOffset + 0] & 0xFFL) << 56 | ((long)buffer[byteOffset + 1] & 0xFFL) << 48 | ((long)buffer[byteOffset + 2] & 0xFFL) << 40 | ((long)buffer[byteOffset + 3] & 0xFFL) << 32 | ((long)buffer[byteOffset + 4] & 0xFFL) << 24 | ((long)buffer[byteOffset + 5] & 0xFFL) << 16 | ((long)buffer[byteOffset + 6] & 0xFFL) << 8 | (long)buffer[byteOffset + 7] & 0xFFL;
    }

    @Override
    public long getLong(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        assert (byteOffset < Integer.MAX_VALUE);
        return this.getLong(buffer, (int)byteOffset);
    }

    @Override
    public void putLong(byte[] buffer, int byteOffset, long value) throws IndexOutOfBoundsException {
        buffer[byteOffset + 0] = (byte)(value >> 56);
        buffer[byteOffset + 1] = (byte)(value >> 48);
        buffer[byteOffset + 2] = (byte)(value >> 40);
        buffer[byteOffset + 3] = (byte)(value >> 32);
        buffer[byteOffset + 4] = (byte)(value >> 24);
        buffer[byteOffset + 5] = (byte)(value >> 16);
        buffer[byteOffset + 6] = (byte)(value >> 8);
        buffer[byteOffset + 7] = (byte)value;
    }

    @Override
    public void putLong(byte[] buffer, long byteOffset, long value) throws IndexOutOfBoundsException {
        assert (byteOffset < Integer.MAX_VALUE);
        this.putLong(buffer, (int)byteOffset, value);
    }

    @Override
    public float getFloat(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return Float.intBitsToFloat(this.getInt(buffer, byteOffset));
    }

    @Override
    public float getFloat(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        assert (byteOffset < Integer.MAX_VALUE);
        return this.getFloat(buffer, (int)byteOffset);
    }

    @Override
    public void putFloat(byte[] buffer, int byteOffset, float value) throws IndexOutOfBoundsException {
        this.putInt(buffer, byteOffset, Float.floatToRawIntBits(value));
    }

    @Override
    public void putFloat(byte[] buffer, long byteOffset, float value) throws IndexOutOfBoundsException {
        assert (byteOffset < Integer.MAX_VALUE);
        this.putFloat(buffer, (int)byteOffset, value);
    }

    @Override
    public double getDouble(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return Double.longBitsToDouble(this.getLong(buffer, byteOffset));
    }

    @Override
    public double getDouble(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        assert (byteOffset < Integer.MAX_VALUE);
        return this.getDouble(buffer, (int)byteOffset);
    }

    @Override
    public void putDouble(byte[] buffer, int byteOffset, double value) throws IndexOutOfBoundsException {
        this.putLong(buffer, byteOffset, Double.doubleToRawLongBits(value));
    }

    @Override
    public void putDouble(byte[] buffer, long byteOffset, double value) throws IndexOutOfBoundsException {
        assert (byteOffset < Integer.MAX_VALUE);
        this.putDouble(buffer, (int)byteOffset, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByteVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            return this.getByte(buffer, byteOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putByteVolatile(byte[] buffer, long byteOffset, byte value) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            this.putByte(buffer, byteOffset, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShortVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            return this.getShort(buffer, byteOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putShortVolatile(byte[] buffer, long byteOffset, short value) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            this.putShort(buffer, byteOffset, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIntVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            return this.getInt(buffer, byteOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putIntVolatile(byte[] buffer, long byteOffset, int value) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            this.putInt(buffer, byteOffset, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLongVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            return this.getLong(buffer, byteOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putLongVolatile(byte[] buffer, long byteOffset, long value) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            this.putLong(buffer, byteOffset, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getAndAddByte(byte[] buffer, long byteOffset, byte delta) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            byte v = this.getByte(buffer, byteOffset);
            this.putByte(buffer, byteOffset, (byte)(v + delta));
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getAndAddShort(byte[] buffer, long byteOffset, short delta) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            short v = this.getShort(buffer, byteOffset);
            this.putShort(buffer, byteOffset, (short)(v + delta));
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAndAddInt(byte[] buffer, long byteOffset, int delta) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            int v = this.getInt(buffer, byteOffset);
            this.putInt(buffer, byteOffset, v + delta);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAndAddLong(byte[] buffer, long byteOffset, long delta) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            long v = this.getLong(buffer, byteOffset);
            this.putLong(buffer, byteOffset, v + delta);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getAndBitwiseAndByte(byte[] buffer, long byteOffset, byte mask) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            byte v = this.getByte(buffer, byteOffset);
            this.putByte(buffer, byteOffset, (byte)(v & mask));
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getAndBitwiseAndShort(byte[] buffer, long byteOffset, short mask) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            short v = this.getShort(buffer, byteOffset);
            this.putShort(buffer, byteOffset, (short)(v & mask));
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAndBitwiseAndInt(byte[] buffer, long byteOffset, int mask) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            int v = this.getInt(buffer, byteOffset);
            this.putInt(buffer, byteOffset, v & mask);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAndBitwiseAndLong(byte[] buffer, long byteOffset, long mask) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            long v = this.getLong(buffer, byteOffset);
            this.putLong(buffer, byteOffset, v & mask);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getAndBitwiseOrByte(byte[] buffer, long byteOffset, byte mask) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            byte v = this.getByte(buffer, byteOffset);
            this.putByte(buffer, byteOffset, (byte)(v | mask));
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getAndBitwiseOrShort(byte[] buffer, long byteOffset, short mask) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            short v = this.getShort(buffer, byteOffset);
            this.putShort(buffer, byteOffset, (short)(v | mask));
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAndBitwiseOrInt(byte[] buffer, long byteOffset, int mask) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            int v = this.getInt(buffer, byteOffset);
            this.putInt(buffer, byteOffset, v | mask);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAndBitwiseOrLong(byte[] buffer, long byteOffset, long mask) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            long v = this.getLong(buffer, byteOffset);
            this.putLong(buffer, byteOffset, v | mask);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getAndBitwiseXorByte(byte[] buffer, long byteOffset, byte mask) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            byte v = this.getByte(buffer, byteOffset);
            this.putByte(buffer, byteOffset, (byte)(v ^ mask));
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getAndBitwiseXorShort(byte[] buffer, long byteOffset, short mask) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            short v = this.getShort(buffer, byteOffset);
            this.putShort(buffer, byteOffset, (short)(v ^ mask));
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAndBitwiseXorInt(byte[] buffer, long byteOffset, int mask) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            int v = this.getInt(buffer, byteOffset);
            this.putInt(buffer, byteOffset, v ^ mask);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAndBitwiseXorLong(byte[] buffer, long byteOffset, long mask) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            long v = this.getLong(buffer, byteOffset);
            this.putLong(buffer, byteOffset, v ^ mask);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getAndSetByte(byte[] buffer, long byteOffset, byte newValue) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            byte v = this.getByte(buffer, byteOffset);
            this.putByte(buffer, byteOffset, newValue);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getAndSetShort(byte[] buffer, long byteOffset, short newValue) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            short v = this.getShort(buffer, byteOffset);
            this.putShort(buffer, byteOffset, newValue);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAndSetInt(byte[] buffer, long byteOffset, int newValue) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            int v = this.getInt(buffer, byteOffset);
            this.putInt(buffer, byteOffset, newValue);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAndSetLong(byte[] buffer, long byteOffset, long newValue) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            long v = this.getLong(buffer, byteOffset);
            this.putLong(buffer, byteOffset, newValue);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte compareAndExchangeByte(byte[] buffer, long byteOffset, byte expected, byte x) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            byte v = this.getByte(buffer, byteOffset);
            if (v == expected) {
                this.putByte(buffer, byteOffset, x);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short compareAndExchangeShort(byte[] buffer, long byteOffset, short expected, short x) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            short v = this.getShort(buffer, byteOffset);
            if (v == expected) {
                this.putShort(buffer, byteOffset, x);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compareAndExchangeInt(byte[] buffer, long byteOffset, int expected, int x) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            int v = this.getInt(buffer, byteOffset);
            if (v == expected) {
                this.putInt(buffer, byteOffset, x);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long compareAndExchangeLong(byte[] buffer, long byteOffset, long expected, long x) throws IndexOutOfBoundsException {
        SimpleByteArraySupportLock simpleByteArraySupportLock = this.lock;
        synchronized (simpleByteArraySupportLock) {
            long v = this.getLong(buffer, byteOffset);
            if (v == expected) {
                this.putLong(buffer, byteOffset, x);
            }
            return v;
        }
    }
}

