/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.util.Map;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.slf4j.MDC;

public class PreservingThreadContextExecutorCallback
implements CompletableComponentExecutor.ExecutorCallback {
    private final CompletableComponentExecutor.ExecutorCallback delegate;
    private final ClassLoader classLoader;
    private final Map<String, String> mdc;

    public PreservingThreadContextExecutorCallback(CompletableComponentExecutor.ExecutorCallback delegate) {
        this.delegate = delegate;
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.mdc = MDC.getCopyOfContextMap();
    }

    public void complete(Object value) {
        try (ThreadContext ignored = new ThreadContext(this.classLoader, this.mdc);){
            this.delegate.complete(value);
        }
    }

    public void error(Throwable e) {
        try (ThreadContext ignored = new ThreadContext(this.classLoader, this.mdc);){
            this.delegate.error(e);
        }
    }

    private static class ThreadContext
    implements AutoCloseable {
        private final Thread currentThread = Thread.currentThread();
        private final ClassLoader innerClassLoader;
        private final Map<String, String> innerMDC;
        private final ClassLoader outerClassLoader;
        private final Map<String, String> outerMDC;

        ThreadContext(ClassLoader classLoader, Map<String, String> mdc) {
            this.innerClassLoader = classLoader;
            this.innerMDC = mdc;
            this.outerClassLoader = this.currentThread.getContextClassLoader();
            this.outerMDC = MDC.getCopyOfContextMap();
            MDC.setContextMap(this.innerMDC);
            ClassUtils.setContextClassLoader((Thread)this.currentThread, (ClassLoader)this.outerClassLoader, (ClassLoader)this.innerClassLoader);
        }

        @Override
        public void close() {
            try {
                ClassUtils.setContextClassLoader((Thread)this.currentThread, (ClassLoader)this.innerClassLoader, (ClassLoader)this.outerClassLoader);
            }
            finally {
                MDC.setContextMap(this.outerMDC);
            }
        }
    }
}

