/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.compression;

import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.GzipOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.util.internal.ObjectUtil;
import reactor.netty.http.server.compression.HttpCompressionOption;

public final class GzipOption
implements HttpCompressionOption {
    private final int compressionLevel;
    private final int memoryLevel;
    private final int windowBits;

    private GzipOption(Build build) {
        this.compressionLevel = build.compressionLevel;
        this.memoryLevel = build.memoryLevel;
        this.windowBits = build.windowBits;
    }

    static GzipOption provideDefault() {
        return GzipOption.builder().build();
    }

    CompressionOptions adapt() {
        return StandardCompressionOptions.gzip((int)this.compressionLevel, (int)this.windowBits, (int)this.memoryLevel);
    }

    public static Builder builder() {
        return new Build();
    }

    private static final class Build
    implements Builder {
        static final GzipOptions DEFAULT = StandardCompressionOptions.gzip();
        private int compressionLevel = DEFAULT.compressionLevel();
        private int memoryLevel = DEFAULT.memLevel();
        private int windowBits = DEFAULT.windowBits();

        private Build() {
        }

        @Override
        public GzipOption build() {
            return new GzipOption(this);
        }

        @Override
        public Builder compressionLevel(int compressionLevel) {
            ObjectUtil.checkInRange((int)compressionLevel, (int)0, (int)9, (String)"compressionLevel");
            this.compressionLevel = compressionLevel;
            return this;
        }

        @Override
        public Builder memoryLevel(int memoryLevel) {
            ObjectUtil.checkInRange((int)memoryLevel, (int)1, (int)9, (String)"memoryLevel");
            this.memoryLevel = memoryLevel;
            return this;
        }

        @Override
        public Builder windowBits(int windowBits) {
            ObjectUtil.checkInRange((int)windowBits, (int)9, (int)15, (String)"windowBits");
            this.windowBits = windowBits;
            return this;
        }
    }

    public static interface Builder {
        public GzipOption build();

        public Builder compressionLevel(int var1);

        public Builder memoryLevel(int var1);

        public Builder windowBits(int var1);
    }
}

