/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.server;

import io.qameta.allure.Issue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.server.AbstractHttpServerTestCase;

@Issue(value="W-19810563")
public class HttpServerConnectionTimeoutTestCase
extends AbstractHttpServerTestCase {
    private static final int CONNECTION_IDLE_TIMEOUT = 1000;
    private static final String REQUEST_PATH = "/slower-than-idle-connection-timeout";
    private ScheduledExecutorService executorService;

    public HttpServerConnectionTimeoutTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setup() throws Exception {
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.setUpServer();
        this.server.addRequestHandler(REQUEST_PATH, (reqCtx, respCb) -> this.executorService.submit(() -> {
            try {
                long longerThanConnectionTimeout = 1100L;
                Thread.sleep(longerThanConnectionTimeout);
                HttpResponse res = HttpResponse.builder().statusCode(Integer.valueOf(200)).build();
                respCb.responseReady(res, (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                HttpResponse res = HttpResponse.builder().statusCode(Integer.valueOf(500)).build();
                respCb.responseReady(res, (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
            }
        }));
    }

    @After
    public void shutdownExecutorService() {
        this.executorService.shutdownNow();
    }

    @Override
    protected String getServerName() {
        return "small-idle-timeout";
    }

    @Override
    protected HttpServerConfiguration.Builder configureServer(HttpServerConfiguration.Builder builder) {
        return builder.setConnectionIdleTimeout(1000);
    }

    @Test
    public void connectionTimeoutShouldNotInterruptInflightRequestProcessing() throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet httpPost = new HttpGet(this.getUri(REQUEST_PATH));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
            }
        }
    }

    protected String getUri(String path) {
        return "http://localhost:" + this.port.getNumber() + path;
    }
}

