/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence;

import java.io.IOException;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.persistence.AbstractJsonMetadataTypeWriter;
import org.mule.metadata.persistence.NullObjectTypeReferenceHandler;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.metadata.persistence.serializer.TypeSerializerVisitor;

public class JsonMetadataTypeWriter
extends AbstractJsonMetadataTypeWriter {
    private final ObjectTypeReferenceHandler referenceHandler;
    private boolean allowNullInput = false;

    public JsonMetadataTypeWriter() {
        this(new NullObjectTypeReferenceHandler());
    }

    public JsonMetadataTypeWriter(ObjectTypeReferenceHandler referenceHandler) {
        this.referenceHandler = referenceHandler;
    }

    public JsonMetadataTypeWriter(ObjectTypeReferenceHandler referenceHandler, boolean allowNullInput) {
        this(referenceHandler);
        this.allowNullInput = allowNullInput;
    }

    @Override
    protected void write(MetadataType type) throws IOException {
        if (type == null && this.allowNullInput) {
            this.writer.setSerializeNulls(true);
            this.writer.nullValue();
            this.writer.setSerializeNulls(false);
        } else {
            type.accept((MetadataTypeVisitor)this.getVisitor());
        }
    }

    protected TypeSerializerVisitor getVisitor() {
        return new TypeSerializerVisitor(this.writer, this.referenceHandler, this.typeStack, true);
    }

    @Override
    public JsonMetadataTypeWriter setPrettyPrint(boolean prettyPrint) {
        super.setPrettyPrint(prettyPrint);
        return this;
    }
}

