/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.util;

import io.netty.handler.codec.DecoderException;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.SSLHandshakeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.netty.http.client.PrematureCloseException;

public class NettyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyUtils.class);

    public static boolean shouldWrapAsRemotelyClosed(Throwable exception) {
        if (NettyUtils.isConnectionReset(exception)) {
            return true;
        }
        if (exception instanceof ClosedChannelException && NettyUtils.hasSuppressedSSLException(exception)) {
            return true;
        }
        if (exception instanceof DecoderException) {
            LOGGER.warn("Caught exception. Interpreting it as a Remotely Closed", exception);
            return true;
        }
        return exception instanceof PrematureCloseException;
    }

    private static boolean isConnectionReset(Throwable exception) {
        if (exception == null) {
            return false;
        }
        String message = exception.getMessage();
        if (message == null) {
            return false;
        }
        return message.contains("Connection reset");
    }

    private static boolean hasSuppressedSSLException(Throwable exception) {
        return exception.getSuppressed() != null && exception.getSuppressed().length > 0 && exception.getSuppressed()[0] instanceof SSLHandshakeException;
    }
}

