/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.util;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.net.HttpCookie;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;

public class RedirectHelper {
    private static final Pattern MAX_AGE_PATTERN = Pattern.compile("(?i)Max-Age=([-]?\\d+)");
    private static final Pattern EXPIRES_PATTERN = Pattern.compile("(?i)Expires=([^;]+)");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.US).withZone(ZoneId.of("GMT"));
    private final Map<String, String> cookiesMap = new LinkedHashMap<String, String>();
    private int responseStatusCode = -1;

    public RedirectHelper(HttpHeaders httpsHeaders) {
        if (httpsHeaders != null && httpsHeaders.contains((CharSequence)HttpHeaderNames.COOKIE)) {
            List cookies = httpsHeaders.getAll((CharSequence)HttpHeaderNames.COOKIE);
            cookies.stream().map(RedirectHelper::extractKeyValueAndConvertToHttpCookie).filter(Objects::nonNull).forEach(parsedCookie -> this.cookiesMap.put(parsedCookie.getName(), parsedCookie.getValue()));
        }
    }

    public void handleRedirectResponse(HttpClientResponse response) {
        HttpHeaders headers = response.responseHeaders();
        if (headers.contains((CharSequence)HttpHeaderNames.SET_COOKIE)) {
            this.filterExpiredCookies(headers);
        }
        this.responseStatusCode = response.status().code();
    }

    public void addCookiesToRedirectedRequest(HttpClientRequest redirectRequest) {
        if (this.cookiesMap.isEmpty()) {
            return;
        }
        StringBuilder cookieHeader = new StringBuilder();
        this.cookiesMap.forEach((key, value) -> {
            if (!cookieHeader.isEmpty()) {
                cookieHeader.append("; ");
            }
            cookieHeader.append((String)key).append("=").append((String)value);
        });
        redirectRequest.requestHeaders().set((CharSequence)HttpHeaderNames.COOKIE, (Object)cookieHeader.toString());
    }

    public Boolean shouldChangeMethod() {
        return 302 == this.responseStatusCode || 303 == this.responseStatusCode;
    }

    public boolean isRedirectStatusCode(int statusCode) {
        return statusCode >= 300 && statusCode <= 399;
    }

    private static HttpCookie extractKeyValueAndConvertToHttpCookie(String cookieString) {
        String[] parts = cookieString.split(";\\s*");
        String[] nameValue = parts[0].split("=", 2);
        if (nameValue.length != 2) {
            return null;
        }
        return new HttpCookie(nameValue[0].trim(), nameValue[1].trim());
    }

    private static boolean isCookieExpired(String setCookieHeader) {
        Matcher maxAgeMatcher = MAX_AGE_PATTERN.matcher(setCookieHeader);
        Matcher expiresMatcher = EXPIRES_PATTERN.matcher(setCookieHeader);
        Long expiryTime = null;
        long currentTime = System.currentTimeMillis();
        if (maxAgeMatcher.find()) {
            int maxAge = Integer.parseInt(maxAgeMatcher.group(1));
            if (maxAge <= 0) {
                return true;
            }
            expiryTime = currentTime + (long)maxAge * 1000L;
        } else if (expiresMatcher.find()) {
            String expiresValue = expiresMatcher.group(1).trim();
            expiryTime = RedirectHelper.parseExpiresDate(expiresValue);
        }
        return expiryTime != null && currentTime > expiryTime;
    }

    private static Long parseExpiresDate(String expiresValue) {
        ZonedDateTime zdt = ZonedDateTime.parse(expiresValue, DATE_FORMATTER);
        return zdt.toInstant().toEpochMilli();
    }

    private void filterExpiredCookies(HttpHeaders headers) {
        List cookieStrings = headers.getAll((CharSequence)HttpHeaderNames.SET_COOKIE);
        cookieStrings.stream().filter(cookieString -> cookieString != null && !RedirectHelper.isCookieExpired(cookieString)).forEach(cookieString -> {
            if (cookieString.contains("Expires=")) {
                HttpCookie httpCookie = RedirectHelper.extractKeyValueAndConvertToHttpCookie(cookieString);
                if (httpCookie != null) {
                    this.cookiesMap.put(httpCookie.getName(), httpCookie.getValue());
                }
            } else {
                for (HttpCookie cookie : HttpCookie.parse(cookieString)) {
                    this.cookiesMap.put(cookie.getName(), cookie.getValue());
                }
            }
        });
    }
}

