/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.context;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.spi.FeatureManagerProvider;

public class JNDIFeatureManagerProvider
implements FeatureManagerProvider {
    public static final String JNDI_NAME = "java:/comp/env/FeatureManager";
    private final Logger log = LoggerFactory.getLogger(JNDIFeatureManagerProvider.class);

    @Override
    public int priority() {
        return 200;
    }

    @Override
    public FeatureManager getFeatureManager() {
        if (!this.isDisabled()) {
            try {
                InitialContext initialContext = new InitialContext();
                return (FeatureManager)initialContext.lookup(JNDI_NAME);
            }
            catch (NamingException e) {
                this.log.debug("FeatureManager not found: " + e.getMessage());
            }
        }
        return null;
    }

    private boolean isDisabled() {
        return "true".equals(System.getProperty("org.togglz.DISABLE_JNDI_LOOKUPS", ""));
    }
}

