/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCounted;
import java.util.List;

public class ConditionalRequestAggregator
extends MessageToMessageDecoder<HttpObject> {
    private HttpRequest requestHeader;

    protected void decode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) throws Exception {
        if (httpObject instanceof FullHttpRequest) {
            this.stepAside(httpObject, list);
            return;
        }
        if (httpObject.decoderResult().isFailure()) {
            this.stepAside(httpObject, list);
            return;
        }
        if (httpObject instanceof HttpRequest) {
            HttpRequest httpRequest;
            this.requestHeader = httpRequest = (HttpRequest)httpObject;
            return;
        }
        if (this.requestHeader != null && httpObject instanceof LastHttpContent) {
            LastHttpContent lastHttpContent = (LastHttpContent)httpObject;
            lastHttpContent.retain();
            FullHttpRequest aggregatedRequest = ConditionalRequestAggregator.combine(this.requestHeader, lastHttpContent.content());
            this.requestHeader = null;
            list.add(aggregatedRequest);
            return;
        }
        this.stepAside(httpObject, list);
    }

    private static FullHttpRequest combine(HttpRequest request, ByteBuf content) {
        return new DefaultFullHttpRequest(request.protocolVersion(), request.method(), request.uri(), content, request.headers(), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    }

    private void stepAside(HttpObject httpObject, List<Object> list) {
        if (this.requestHeader != null) {
            list.add(this.requestHeader);
            this.requestHeader = null;
        }
        if (httpObject instanceof ReferenceCounted) {
            ReferenceCounted referenceCounted = (ReferenceCounted)httpObject;
            referenceCounted.retain();
        }
        list.add(httpObject);
    }
}

