/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.util;

import java.util.Collections;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.mule.runtime.http.api.domain.message.MessageWithHeaders;

public class HttpMessageHeaderMatcher
extends TypeSafeMatcher<MessageWithHeaders> {
    private final Map<String, String> headers;

    public static Matcher<MessageWithHeaders> hasHeaders(Map<String, String> headers) {
        return new HttpMessageHeaderMatcher(headers);
    }

    public static Matcher<MessageWithHeaders> hasHeader(String headerName, String headerValue) {
        return HttpMessageHeaderMatcher.hasHeaders(Collections.singletonMap(headerName, headerValue));
    }

    public HttpMessageHeaderMatcher(Map<String, String> headers) {
        this.headers = headers;
    }

    protected boolean matchesSafely(MessageWithHeaders item) {
        for (Map.Entry<String, String> expectedHeaderPair : this.headers.entrySet()) {
            String actual = item.getHeaderValue(expectedHeaderPair.getKey());
            if (expectedHeaderPair.getValue().equals(actual)) continue;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("Expected an HTTP Message with headers: ").appendValue(this.headers);
    }

    protected void describeMismatchSafely(MessageWithHeaders item, Description mismatchDescription) {
        mismatchDescription.appendText("seen headers ").appendValue((Object)item.getHeaders());
    }
}

