/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.DefaultSuggestion;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class StringValueRule
extends Rule {
    private String value;
    private String description;
    private boolean caseSensitive = true;

    public StringValueRule(String value) {
        this.value = value;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Collections.singletonList(new DefaultSuggestion(this.value, this.description, StringUtils.capitalize((String)this.value)));
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return node instanceof StringNode && (this.caseSensitive ? ((StringNode)node).getValue().equals(this.value) : ((StringNode)node).getValue().equalsIgnoreCase(this.value));
    }

    public StringValueRule description(String description) {
        this.description = description;
        return this;
    }

    public StringValueRule caseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    @Override
    @Nonnull
    public Node apply(@Nonnull Node node) {
        if (!(node instanceof StringNode)) {
            return ErrorNodeFactory.createInvalidType(node, NodeType.String);
        }
        if (!this.matches(node)) {
            return ErrorNodeFactory.createInvalidValue(node, this.value);
        }
        return this.createNodeUsingFactory(node, ((StringNode)node).getValue());
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public String getDescription() {
        return "\"" + this.value + "\"";
    }

    public String getValue() {
        return this.value;
    }
}

