/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.model.values.coercion;

import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.Locale;
import org.mule.weave.v2.core.exception.InvalidNumberException;
import org.mule.weave.v2.core.exception.InvalidNumberFormatException;
import org.mule.weave.v2.core.exception.InvalidUnitException;
import org.mule.weave.v2.core.exception.UnsupportedTypeCoercionException$;
import org.mule.weave.v2.core.exception.UnsupportedTypeCoercionToLiteralException$;
import org.mule.weave.v2.core.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.KeyType$;
import org.mule.weave.v2.model.types.NameType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.PeriodType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.values.NumberValue;
import org.mule.weave.v2.model.values.NumberValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.coercion.NumberUtils;
import org.mule.weave.v2.model.values.coercion.NumberUtils$;
import org.mule.weave.v2.model.values.coercion.ValueCoercer;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.model.values.math.Number$;
import org.mule.weave.v2.parser.ast.structure.schema.TimeUnit$;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.math.BigDecimal$;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0006\r\u0001mA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006i\u0001!\t!\u000e\u0005\u0006q\u0001!\t%\u000f\u0005\u0006O\u0002!I\u0001\u001b\u0005\u0006m\u0002!\ta\u001e\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\t\t\u0002\u0001C\u0005\u0003o9q!!\u0011\r\u0011\u0003\t\u0019E\u0002\u0004\f\u0019!\u0005\u0011Q\t\u0005\u0007i%!\t!a\u0012\u0003\u001b9+XNY3s\u0007>,'oY3s\u0015\tia\"\u0001\u0005d_\u0016\u00148-[8o\u0015\ty\u0001#\u0001\u0004wC2,Xm\u001d\u0006\u0003#I\tQ!\\8eK2T!a\u0005\u000b\u0002\u0005Y\u0014$BA\u000b\u0017\u0003\u00159X-\u0019<f\u0015\t9\u0002$\u0001\u0003nk2,'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VM\u001a\t\u0004G\u00112S\"\u0001\u0007\n\u0005\u0015b!\u0001\u0004,bYV,7i\\3sG\u0016\u0014\bCA\u0014)\u001b\u0005q\u0011BA\u0015\u000f\u0005-qU/\u001c2feZ\u000bG.^3\u0002\u000bY\fG.^3\u0011\u0007uac&\u0003\u0002.=\t1q\n\u001d;j_:\u0004\"a\f\u001a\u000e\u0003AR!!\r\b\u0002\t5\fG\u000f[\u0005\u0003gA\u0012aAT;nE\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u00027oA\u00111\u0005\u0001\u0005\u0006U\t\u0001\raK\u0001\u0007G>,'oY3\u0015\ti\n%+\u0018\u000b\u0003MmBQ\u0001P\u0002A\u0004u\n\u0011#\u001a<bYV\fG/[8o\u0007>tG/\u001a=u!\tqt(D\u0001\u0011\u0013\t\u0001\u0005CA\tFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqRDQAQ\u0002A\u0002\r\u000b\u0011a\u0019\u0019\u0003\t&\u00032aJ#H\u0013\t1eBA\u0003WC2,X\r\u0005\u0002I\u00132\u0001A!\u0003&B\u0003\u0003\u0005\tQ!\u0001L\u0005\ryF%M\t\u0003\u0019>\u0003\"!H'\n\u00059s\"a\u0002(pi\"Lgn\u001a\t\u0003;AK!!\u0015\u0010\u0003\u0007\u0005s\u0017\u0010C\u0003T\u0007\u0001\u0007A+\u0001\u0007uCJ<W\r^*dQ\u0016l\u0017\rE\u0002\u001eYU\u0003\"AV.\u000e\u0003]S!\u0001W-\u0002\rM\u001c\u0007.Z7b\u0015\tQ\u0006#A\u0005tiJ,8\r^;sK&\u0011Al\u0016\u0002\u0007'\u000eDW-\\1\t\u000by\u001b\u0001\u0019A0\u0002\u001f1|7-\u0019;j_:\u001c\u0015\r]1cY\u0016\u0004\"\u0001Y3\u000e\u0003\u0005T!AY2\u0002\u00111|7-\u0019;j_:T!\u0001\u001a\n\u0002\rA\f'o]3s\u0013\t1\u0017MA\bM_\u000e\fG/[8o\u0007\u0006\u0004\u0018M\u00197f\u00039\u0001XM]5pIR{g*^7cKJ$B!\u001b8ukR\u0011!.\u001c\t\u0003;-L!\u0001\u001c\u0010\u0003\t1{gn\u001a\u0005\u0006y\u0011\u0001\u001d!\u0010\u0005\u0006\u0005\u0012\u0001\ra\u001c\u0019\u0003aJ\u00042aJ#r!\tA%\u000fB\u0005t]\u0006\u0005\t\u0011!B\u0001\u0017\n\u0019q\f\n\u001a\t\u000ba#\u0001\u0019\u0001+\t\u000by#\u0001\u0019A0\u0002\u0011Q|g*^7cKJ$b\u0001_>\u0002\f\u0005=AC\u0001\u0018z\u0011\u0015QX\u0001q\u0001>\u0003\r\u0019G\u000f\u001f\u0005\u0006y\u0016\u0001\r!`\u0001\u000eu>tW\r\u001a#bi\u0016$\u0016.\\3\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\tQLW.\u001a\u0006\u0003\u0003\u000b\tAA[1wC&\u0019\u0011\u0011B@\u0003\u001bi{g.\u001a3ECR,G+[7f\u0011\u0019\ti!\u0002a\u0001)\u0006Qq/\u001b;i'\u000eDW-\\1\t\u000by+\u0001\u0019A0\u0002\u0017A\f'o]3Ok6\u0014WM\u001d\u000b\t\u0003+\tI\"a\r\u00026Q\u0019a&a\u0006\t\u000bi4\u00019A\u001f\t\u000f\u0005ma\u00011\u0001\u0002\u001e\u0005\u00191\u000f\u001e:\u0011\t\u0005}\u0011Q\u0006\b\u0005\u0003C\tI\u0003E\u0002\u0002$yi!!!\n\u000b\u0007\u0005\u001d\"$\u0001\u0004=e>|GOP\u0005\u0004\u0003Wq\u0012A\u0002)sK\u0012,g-\u0003\u0003\u00020\u0005E\"AB*ue&twMC\u0002\u0002,yAa!!\u0004\u0007\u0001\u0004!\u0006\"\u00020\u0007\u0001\u0004yFCBA\u001d\u0003{\ty\u0004F\u0002/\u0003wAQA_\u0004A\u0004uBq!a\u0007\b\u0001\u0004\ti\u0002C\u0003_\u000f\u0001\u0007q,A\u0007Ok6\u0014WM]\"pKJ\u001cWM\u001d\t\u0003G%\u0019\"!\u0003\u001c\u0015\u0005\u0005\r\u0003")
public class NumberCoercer
implements ValueCoercer<NumberValue> {
    private final Option<Number> value;

    @Override
    public Option<NumberValue> coerceMaybe(Value<?> value, Option<Schema> targetSchema, LocationCapable locationCapable, EvaluationContext evaluationContext) {
        return ValueCoercer.coerceMaybe$(this, value, targetSchema, locationCapable, evaluationContext);
    }

    @Override
    public NumberValue coerce(Value<?> c, Option<Schema> targetSchema, LocationCapable locationCapable, EvaluationContext evaluationContext) {
        Number number;
        Value<?> value = c;
        if (NumberType$.MODULE$.accepts(value, evaluationContext)) {
            number = (Number)c.evaluate(evaluationContext);
        } else if (DateTimeType$.MODULE$.accepts(value, evaluationContext)) {
            number = this.toNumber(((ZonedDateTime)c.evaluate(evaluationContext)).withZoneSameInstant(ZoneOffset.UTC), targetSchema, locationCapable, evaluationContext);
        } else if (PeriodType$.MODULE$.accepts(value, evaluationContext)) {
            number = Number$.MODULE$.apply(this.periodToNumber(c, targetSchema, locationCapable, evaluationContext));
        } else if (StringType$.MODULE$.accepts(value, evaluationContext) | KeyType$.MODULE$.accepts(value, evaluationContext) | NameType$.MODULE$.accepts(value, evaluationContext)) {
            number = this.parseNumber(StringType$.MODULE$.coerce(c, evaluationContext).evaluate(evaluationContext).toString(), targetSchema, locationCapable, evaluationContext);
        } else if (BinaryType$.MODULE$.accepts(value, evaluationContext)) {
            SeekableStream seekableStream = (SeekableStream)BinaryType$.MODULE$.coerce(c, evaluationContext).evaluate(evaluationContext);
            number = Number$.MODULE$.apply(((InputStream)((Object)seekableStream)).read());
        } else {
            Option<Number> option = this.value;
            if (option instanceof Some) {
                Some some = (Some)option;
                Number expectedNumber = (Number)some.value();
                throw UnsupportedTypeCoercionToLiteralException$.MODULE$.apply(locationCapable.location(), c.valueType(evaluationContext), NumberType$.MODULE$, expectedNumber.toString(), c, evaluationContext);
            }
            if (None$.MODULE$.equals(option)) {
                throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), c.valueType(evaluationContext), NumberType$.MODULE$, c, evaluationContext);
            }
            throw new MatchError(option);
        }
        Number coercedNumber = number;
        Option<Number> option = this.value;
        if (option instanceof Some) {
            Number expectedNumber;
            Some some = (Some)option;
            Number number2 = expectedNumber = (Number)some.value();
            Number number3 = coercedNumber;
            if (!(number2 != null ? !((Object)number2).equals(number3) : number3 != null)) {
                return NumberValue$.MODULE$.apply(coercedNumber, locationCapable, targetSchema);
            }
            throw UnsupportedTypeCoercionToLiteralException$.MODULE$.apply(locationCapable.location(), c.valueType(evaluationContext), NumberType$.MODULE$, expectedNumber.toString(), c, evaluationContext);
        }
        if (None$.MODULE$.equals(option)) {
            return NumberValue$.MODULE$.apply(coercedNumber, locationCapable, targetSchema);
        }
        throw new MatchError(option);
    }

    private long periodToNumber(Value<?> c, Option<Schema> schema, LocationCapable locationCapable, EvaluationContext evaluationContext) {
        TemporalAmount periodValue = (TemporalAmount)PeriodType$.MODULE$.coerce(c, evaluationContext).evaluate(evaluationContext);
        TemporalAmount temporalAmount = periodValue;
        if (temporalAmount instanceof Duration) {
            Duration duration = (Duration)temporalAmount;
            boolean bl = false;
            Some some = null;
            Option option = schema.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.unit(evaluationContext));
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                String string = (String)some.value();
                String string2 = TimeUnit$.MODULE$.DAYS();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return duration.toDays();
                }
            }
            if (bl) {
                String string = (String)some.value();
                String string4 = TimeUnit$.MODULE$.HOURS();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    return duration.toHours();
                }
            }
            if (bl) {
                String string = (String)some.value();
                String string6 = TimeUnit$.MODULE$.MINUTES();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    return duration.toMinutes();
                }
            }
            if (bl) {
                String string = (String)some.value();
                String string8 = TimeUnit$.MODULE$.SECONDS();
                String string9 = string;
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    return duration.get(ChronoUnit.SECONDS);
                }
            }
            if (bl) {
                String string = (String)some.value();
                String string10 = TimeUnit$.MODULE$.MILLISECONDS();
                String string11 = string;
                if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                    return duration.toMillis();
                }
            }
            if (bl) {
                String string = (String)some.value();
                String string12 = TimeUnit$.MODULE$.NANOS();
                String string13 = string;
                if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                    return duration.toNanos();
                }
            }
            if (bl) {
                String unit = (String)some.value();
                throw new InvalidUnitException(locationCapable.location(), unit, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TimeUnit$.MODULE$.DAYS(), TimeUnit$.MODULE$.HOURS(), TimeUnit$.MODULE$.SECONDS(), TimeUnit$.MODULE$.MINUTES(), TimeUnit$.MODULE$.MILLISECONDS(), TimeUnit$.MODULE$.NANOS()}));
            }
            return duration.get(ChronoUnit.SECONDS);
        }
        if (temporalAmount instanceof Period) {
            Period period = (Period)temporalAmount;
            boolean bl = false;
            Some some = null;
            Option option = schema.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.unit(evaluationContext));
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                String string = (String)some.value();
                String string14 = TimeUnit$.MODULE$.YEARS();
                String string15 = string;
                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                    return (int)(period.toTotalMonths() / 12L);
                }
            }
            if (bl) {
                String string = (String)some.value();
                String string16 = TimeUnit$.MODULE$.MONTHS();
                String string17 = string;
                if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                    return period.toTotalMonths();
                }
            }
            if (bl) {
                String unit = (String)some.value();
                throw new InvalidUnitException(locationCapable.location(), unit, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TimeUnit$.MODULE$.YEARS(), TimeUnit$.MODULE$.MONTHS()}));
            }
            return period.toTotalMonths();
        }
        throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), c.valueType(evaluationContext), NumberType$.MODULE$, c, evaluationContext);
    }

    public Number toNumber(ZonedDateTime zonedDateTime, Option<Schema> withSchema, LocationCapable locationCapable, EvaluationContext ctx) {
        Option numberMaybe = withSchema.flatMap((Function1 & Serializable & scala.Serializable)schema -> schema.unit(ctx).map((Function1 & Serializable & scala.Serializable)unit -> NumberCoercer.toNumber$1(zonedDateTime, unit, locationCapable, zonedDateTime)));
        return (Number)numberMaybe.getOrElse((Function0 & Serializable & scala.Serializable)() -> Number$.MODULE$.apply(NumberCoercer.toEpochSecond$1(zonedDateTime)));
    }

    public Number parseNumber(String str, Option<Schema> withSchema, LocationCapable locationCapable, EvaluationContext ctx) {
        Option<Schema> option = withSchema;
        if (option instanceof Some) {
            Some some = (Some)option;
            Schema schema = (Schema)some.value();
            Schema schemaValue = schema;
            Option<String> option2 = schemaValue.format(ctx);
            if (option2 instanceof Some) {
                Number number;
                block10: {
                    Some some2 = (Some)option2;
                    String f = (String)some2.value();
                    try {
                        java.lang.Number number2;
                        DecimalFormatSymbols formatSymbols = (DecimalFormatSymbols)schemaValue.locale(ctx).map((Function1 & Serializable & scala.Serializable)locale -> DecimalFormatSymbols.getInstance(Locale.forLanguageTag(locale))).getOrElse((Function0 & Serializable & scala.Serializable)() -> DecimalFormatSymbols.getInstance(Locale.getDefault(Locale.Category.FORMAT)));
                        DecimalFormat formatter = new DecimalFormat(f, formatSymbols);
                        formatter.setParseBigDecimal(true);
                        java.lang.Number number3 = number2 = formatter.parse(str);
                        if (number3 instanceof Integer) {
                            Integer n = (Integer)number3;
                            number = Number$.MODULE$.apply(n);
                            break block10;
                        }
                        if (number3 instanceof Long) {
                            Long l = (Long)number3;
                            number = Number$.MODULE$.apply(l);
                            break block10;
                        }
                        if (number3 instanceof Double) {
                            Double d = (Double)number3;
                            number = Number$.MODULE$.apply(d);
                            break block10;
                        }
                        if (number3 instanceof Float) {
                            Float f2 = (Float)number3;
                            number = Number$.MODULE$.apply(f2.floatValue());
                            break block10;
                        }
                        if (number3 instanceof BigInteger) {
                            BigInteger bigInteger = (BigInteger)number3;
                            number = Number$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(bigInteger));
                            break block10;
                        }
                        if (number3 instanceof BigDecimal) {
                            BigDecimal bigDecimal = (BigDecimal)number3;
                            number = Number$.MODULE$.apply(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(bigDecimal));
                            break block10;
                        }
                        throw new MatchError((Object)number3);
                    }
                    catch (Exception exception) {
                        throw new InvalidNumberFormatException(locationCapable.location(), str, f);
                    }
                }
                return number;
            }
            return this.parseNumber(str, locationCapable, ctx);
        }
        return this.parseNumber(str, locationCapable, ctx);
    }

    private Number parseNumber(String str, LocationCapable locationCapable, EvaluationContext ctx) {
        NumberUtils.ParsingResult result = NumberUtils$.MODULE$.fromString(str);
        if (result.resultType() == NumberUtils$.MODULE$.INVALID_DATA()) {
            throw new InvalidNumberException(locationCapable.location(), str, ctx);
        }
        return (Number)result.number().get();
    }

    private static final long toEpochSecond$1(ZonedDateTime zonedDateTime$1) {
        return zonedDateTime$1.toEpochSecond();
    }

    private static final Number toNumber$1(ZonedDateTime zonedDateTime, String unit, LocationCapable locationCapable$1, ZonedDateTime zonedDateTime$1) {
        String string = unit.toLowerCase();
        String string2 = TimeUnit$.MODULE$.MILLISECONDS();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return Number$.MODULE$.apply(zonedDateTime.toInstant().toEpochMilli());
        }
        String string4 = TimeUnit$.MODULE$.SECONDS();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return Number$.MODULE$.apply(NumberCoercer.toEpochSecond$1(zonedDateTime$1));
        }
        throw new InvalidUnitException(locationCapable$1.location(), unit, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TimeUnit$.MODULE$.MILLISECONDS(), TimeUnit$.MODULE$.SECONDS()}));
    }

    public NumberCoercer(Option<Number> value) {
        this.value = value;
        ValueCoercer.$init$(this);
    }
}

