/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.exception;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.error.matcher.ErrorTypeMatcher;
import org.mule.runtime.api.message.error.matcher.ErrorTypeMatcherUtils;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.ErrorHandlerNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.TransactionProfilingEventContext;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.transaction.TransactionUtils;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.exception.ErrorHandlerContextManager;
import org.mule.runtime.core.internal.exception.ExceptionRouter;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.internal.transaction.TransactionAdapter;
import org.mule.runtime.core.internal.util.LocationUtils;
import org.mule.runtime.core.privileged.exception.AbstractDeclaredExceptionListener;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.core.privileged.message.PrivilegedError;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.metrics.api.MeterProvider;
import org.mule.runtime.metrics.api.error.ErrorMetrics;
import org.mule.runtime.metrics.api.error.ErrorMetricsFactory;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

@NoExtend
public abstract class TemplateOnErrorHandler
extends AbstractDeclaredExceptionListener
implements MessagingExceptionHandlerAcceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateOnErrorHandler.class);
    private static final Pattern ERROR_HANDLER_LOCATION_PATTERN = Pattern.compile("[^/]*/[^/]*/[^/]*");
    public static final String MULE_RUNTIME_ERROR_METRICS = "Mule runtime error metrics";
    private ComponentTracer<CoreEvent> componentTracer;
    private boolean fromGlobalErrorHandler = false;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private ErrorTypeRepository errorTypeRepository;
    @Inject
    private ConfigurationProperties configurationProperties;
    @Inject
    private InternalProfilingService profilingService;
    private ProfilingDataProducer<TransactionProfilingEventContext, Object> rollbackProducer;
    @Inject
    private ComponentTracerFactory<CoreEvent> componentTracerFactory;
    protected Optional<String> flowLocation = Optional.empty();
    private MessageProcessorChain configuredMessageProcessors;
    protected Optional<String> when = Optional.empty();
    protected boolean handleException;
    protected String errorType = null;
    protected ErrorTypeMatcher errorTypeMatcher = null;
    private String errorHandlerLocation;
    private boolean isLocalErrorHandlerLocation;
    private final Set<String> componentsReferencingGlobalErrorHandler = new HashSet<String>();
    private final Map<String, FailingComponentHandle> failingComponentHandled = new HashMap<String, FailingComponentHandle>();
    private Optional<ProcessingStrategy> ownedProcessingStrategy;
    private Function<Function<Publisher<CoreEvent>, Publisher<CoreEvent>>, FluxSink<CoreEvent>> fluxFactory;
    private final CopyOnWriteArrayList<String> suppressedErrorTypeMatches = new CopyOnWriteArrayList();
    @Inject
    MeterProvider meterProvider;
    @Inject
    ErrorMetricsFactory errorMetricsFactory;
    private ErrorMetrics errorMetrics;

    public void addGlobalErrorHandlerComponentReference(ComponentLocation location) {
        this.componentsReferencingGlobalErrorHandler.add(location.getLocation());
    }

    public void addGlobalErrorHandlerComponentReference(String name) {
        this.componentsReferencingGlobalErrorHandler.add(name);
    }

    @Override
    public final CoreEvent handleException(Exception exception, CoreEvent event) {
        try {
            return (CoreEvent)this.applyInternal(exception).block();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(Exceptions.unwrap(throwable));
        }
    }

    @Override
    public synchronized void initialise() throws InitialisationException {
        this.componentTracer = this.componentTracerFactory.fromComponent((Component)this);
        this.errorMetrics = this.errorMetricsFactory.create(this.meterProvider.getMeterBuilder(MULE_RUNTIME_ERROR_METRICS).build());
        this.rollbackProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.TX_ROLLBACK);
        super.initialise();
    }

    @Override
    public Consumer<Exception> router(Function<Publisher<CoreEvent>, Publisher<CoreEvent>> publisherPostProcessor, final Consumer<CoreEvent> continueCallback, final Consumer<Throwable> propagateCallback) {
        final FluxSink<CoreEvent> fluxSink = this.fluxFactory.apply(publisherPostProcessor);
        return new ExceptionRouter(){

            public void dispose() {
                fluxSink.complete();
            }

            @Override
            public void accept(Exception error) {
                if (!ErrorHandlerContextManager.isHandling((MessagingException)((Object)error))) {
                    TemplateOnErrorHandler.this.measure((MessagingException)((Object)error));
                }
                fluxSink.next((Object)ErrorHandlerContextManager.addContext(TemplateOnErrorHandler.this, (MessagingException)((Object)error), continueCallback, propagateCallback));
            }
        };
    }

    private void measure(MessagingException error) {
        this.errorMetrics.measure((Throwable)((Object)error));
    }

    @Override
    public Publisher<CoreEvent> apply(Exception exception) {
        return this.applyInternal(exception);
    }

    private Mono<CoreEvent> applyInternal(Exception exception) {
        return Mono.create(sink -> {
            Consumer<Exception> router = this.router(Function.identity(), handledEvent -> sink.success(handledEvent), rethrownError -> sink.error(rethrownError));
            try {
                router.accept(exception);
            }
            finally {
                LifecycleUtils.disposeIfNeeded(router, LOGGER);
            }
        });
    }

    private BiConsumer<Throwable, Object> onRoutingError() {
        return (me, obj) -> {
            try {
                this.logger.error("Exception during exception strategy execution");
                this.getExceptionListener().resolveAndLogException((Throwable)me);
                boolean rollback = false;
                if (obj instanceof CoreEvent) {
                    rollback = this.isOwnedTransaction((CoreEvent)obj, this.getException((CoreEvent)obj));
                } else if (obj instanceof Either && ((Either)obj).getLeft() instanceof MessagingException) {
                    MessagingException exception = (MessagingException)((Object)((Object)((Either)obj).getLeft()));
                    rollback = this.isOwnedTransaction(exception.getEvent(), (Exception)((Object)exception));
                }
                if (rollback) {
                    TransactionUtils.profileTransactionAction(this.rollbackProducer, (ProfilingEventType<TransactionProfilingEventContext>)RuntimeProfilingEventTypes.TX_ROLLBACK, this.getLocation());
                    TransactionCoordination.getInstance().rollbackCurrentTransaction();
                }
            }
            catch (Exception ex) {
                this.logger.warn(ex.getMessage());
            }
            CoreEvent result = this.afterRouting().apply(((MessagingException)((Object)((Object)me))).getEvent());
            this.fireEndNotification(ErrorHandlerContextManager.from(this, ((MessagingException)((Object)((Object)me))).getEvent()).getOriginalEvent(), result, (Throwable)me);
            this.measure((MessagingException)((Object)((Object)me)));
            ErrorHandlerContextManager.resolveHandling((FlowExceptionHandler)this, (MessagingException)((Object)((Object)me)));
        };
    }

    private void fireEndNotification(CoreEvent event, CoreEvent result, Throwable throwable) {
        this.getNotificationFirer().dispatch((Notification)new ErrorHandlerNotification(EnrichedNotificationInfo.createInfo((Event)(result != null ? result : event), (Exception)((Object)(throwable instanceof MessagingException ? (MessagingException)((Object)throwable) : null)), (Component)this.configuredMessageProcessors), this.getLocation(), 2002));
    }

    protected Publisher<CoreEvent> route(Publisher<CoreEvent> eventPublisher) {
        return Flux.from(eventPublisher).transform((Function)this.configuredMessageProcessors);
    }

    @Override
    public void setMessageProcessors(List<Processor> processors) {
        super.setMessageProcessors(processors);
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return this.configuredMessageProcessors == null ? new ArrayList() : Collections.singletonList(this.configuredMessageProcessors);
    }

    private void markExceptionAsHandledIfRequired(Exception exception) {
        if (this.handleException) {
            this.markExceptionAsHandled(exception);
        }
    }

    protected void markExceptionAsHandled(Exception exception) {
        if (exception instanceof MessagingException) {
            ((MessagingException)((Object)exception)).setHandled(true);
        }
    }

    protected CoreEvent nullifyExceptionPayloadIfRequired(CoreEvent event) {
        if (this.handleException) {
            return CoreEvent.builder(event).error(null).build();
        }
        return event;
    }

    @Override
    public void start() throws MuleException {
        if (this.fromGlobalErrorHandler && this.ownedProcessingStrategy.isPresent()) {
            LifecycleUtils.startIfNeeded(this.ownedProcessingStrategy);
        }
        super.start();
    }

    @Override
    public void stop() throws MuleException {
        if (this.fromGlobalErrorHandler && this.ownedProcessingStrategy.isPresent()) {
            LifecycleUtils.stopIfNeeded(this.ownedProcessingStrategy);
        }
        super.stop();
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        Optional<ProcessingStrategy> processingStrategy;
        super.doInitialise();
        if (this.fromGlobalErrorHandler) {
            processingStrategy = Optional.ofNullable(MessageProcessors.getDefaultProcessingStrategyFactory(this.muleContext).create(this.muleContext, this.getLocation().getRootContainerName()));
            LifecycleUtils.initialiseIfNeeded(processingStrategy);
            this.ownedProcessingStrategy = processingStrategy;
        } else if (this.flowLocation.isPresent()) {
            Location location = LocationUtils.globalLocation(this.flowLocation.get());
            processingStrategy = MessageProcessors.getProcessingStrategy(this.locator, location);
        } else {
            processingStrategy = MessageProcessors.getProcessingStrategy(this.locator, this);
        }
        this.configuredMessageProcessors = MessageProcessors.buildNewChainWithListOfProcessors(processingStrategy, this.getMessageProcessors(), NullExceptionHandler.getInstance(), this.componentTracer);
        this.fluxFactory = new OnErrorHandlerFluxObjectFactory(processingStrategy);
        this.errorTypeMatcher = TemplateOnErrorHandler.createErrorType(this.errorTypeRepository, this.errorType, this.configurationProperties);
        if (!this.inDefaultErrorHandler()) {
            this.errorHandlerLocation = this.getLocation().getLocation();
            this.isLocalErrorHandlerLocation = ERROR_HANDLER_LOCATION_PATTERN.matcher(this.errorHandlerLocation).find();
            if (this.isLocalErrorHandlerLocation) {
                this.errorHandlerLocation = this.errorHandlerLocation.substring(0, this.errorHandlerLocation.lastIndexOf(47));
                this.errorHandlerLocation = this.errorHandlerLocation.substring(0, this.errorHandlerLocation.lastIndexOf(47));
            }
        }
    }

    @Override
    public void dispose() {
        if (this.fromGlobalErrorHandler) {
            this.ownedProcessingStrategy.ifPresent(processingStrategy -> LifecycleUtils.disposeIfNeeded(processingStrategy, LOGGER));
        }
        LifecycleUtils.disposeIfNeeded(this.fluxFactory, LOGGER);
        super.dispose();
    }

    @Deprecated
    public static ErrorTypeMatcher createErrorType(ErrorTypeRepository errorTypeRepository, String errorTypeNames, ConfigurationProperties configurationProperties) {
        return TemplateOnErrorHandler.createErrorType(errorTypeRepository, errorTypeNames);
    }

    @Deprecated
    public static ErrorTypeMatcher createErrorType(ErrorTypeRepository errorTypeRepository, String errorTypeNames) {
        return ErrorTypeMatcherUtils.createErrorTypeMatcher((ErrorTypeRepository)errorTypeRepository, (String)errorTypeNames);
    }

    public void setWhen(String when) {
        this.when = Optional.ofNullable(when);
    }

    @Override
    public boolean accept(CoreEvent event) {
        return this.acceptsAll() || this.acceptsErrorType(event) && this.acceptsExpression(event);
    }

    private boolean acceptsErrorType(CoreEvent event) {
        Error error = (Error)event.getError().get();
        return this.errorTypeMatcher == null || this.errorTypeMatcher.match(error.getErrorType()) || this.matchesSuppressedErrorType((PrivilegedError)error);
    }

    private boolean matchesSuppressedErrorType(PrivilegedError error) {
        for (Error suppressedError : error.getSuppressedErrors()) {
            ErrorType suppressedErrorType = suppressedError.getErrorType();
            if (!this.errorTypeMatcher.match(suppressedErrorType)) continue;
            this.warnAboutSuppressedErrorTypeMatch(error.getErrorType(), suppressedErrorType);
            return true;
        }
        return false;
    }

    private void warnAboutSuppressedErrorTypeMatch(ErrorType eventErrorType, ErrorType suppressedErrorType) {
        if (this.suppressedErrorTypeMatches.addIfAbsent(suppressedErrorType.getIdentifier())) {
            this.logger.warn("Expected error type from flow '{}' has matched the following underlying error: {}. Consider changing it to match the reported error: {}.", new Object[]{this.getLocation().getLocation(), suppressedErrorType.getIdentifier(), eventErrorType.getIdentifier()});
        }
    }

    private boolean acceptsExpression(CoreEvent event) {
        return !this.hasWhenExpression() || this.when.map(expr -> this.expressionManager.evaluateBoolean((String)expr, event, this.getLocation())).orElse(true) != false;
    }

    public boolean hasWhenExpression() {
        return this.when.isPresent();
    }

    protected Function<CoreEvent, CoreEvent> afterRouting() {
        return event -> {
            if (event != null) {
                return this.nullifyExceptionPayloadIfRequired((CoreEvent)event);
            }
            return event;
        };
    }

    protected Function<CoreEvent, CoreEvent> beforeRouting() {
        return event -> {
            MessagingException exception = (MessagingException)((Object)((Object)this.getException((CoreEvent)event)));
            this.getNotificationFirer().dispatch((Notification)new ErrorHandlerNotification(EnrichedNotificationInfo.createInfo((Event)event, (Exception)((Object)exception), (Component)this.configuredMessageProcessors), this.getLocation(), 2001));
            if (this.getEnableNotifications()) {
                this.getExceptionListener().fireNotification((Exception)((Object)exception), (CoreEvent)event);
            }
            this.logException((Throwable)((Object)exception), (CoreEvent)event);
            this.getExceptionListener().processStatistics();
            this.markExceptionAsHandledIfRequired((Exception)((Object)exception));
            return event;
        };
    }

    protected Exception getException(CoreEvent event) {
        return ErrorHandlerContextManager.from(this, event).getException();
    }

    protected Error getError(CoreEvent event) {
        return ((MessagingException)((Object)this.getException(event))).getEvent().getError().orElse(null);
    }

    protected boolean logException(Throwable t, CoreEvent event) {
        if (Boolean.TRUE.toString().equals(this.getLogException()) || !Boolean.FALSE.toString().equals(this.getLogException()) && this.expressionManager.evaluateBoolean(this.getLogException(), event, this.getLocation(), true, true)) {
            return this.getExceptionListener().resolveAndLogException(t);
        }
        return false;
    }

    public void setHandleException(boolean handleException) {
        this.handleException = handleException;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public void setRootContainerName(String rootContainerName) {
        ComponentAnnotations.updateRootContainerName(rootContainerName, this);
    }

    public void setFlowLocation(ComponentLocation location) {
        this.flowLocation = Optional.ofNullable(location).map(this::normalizeLocation);
    }

    private String normalizeLocation(ComponentLocation loc) {
        String location = loc.getLocation();
        if (location.endsWith("/errorHandler")) {
            return location.substring(0, location.lastIndexOf(47));
        }
        return location;
    }

    public abstract TemplateOnErrorHandler duplicateFor(ComponentLocation var1);

    protected boolean isOwnedTransaction(CoreEvent event, Exception exception) {
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (transaction == null || !(transaction instanceof TransactionAdapter) || !((TransactionAdapter)transaction).getComponentLocation().isPresent()) {
            return false;
        }
        TransactionAdapter txAdapter = (TransactionAdapter)transaction;
        if (this.inDefaultErrorHandler()) {
            return this.defaultErrorHandlerOwnsTransaction(txAdapter);
        }
        if (this.fromGlobalErrorHandler && exception != null) {
            String transactionLocation;
            String tempTransactionLocation = txAdapter.getComponentLocation().get().getLocation();
            if (tempTransactionLocation.endsWith("/source")) {
                tempTransactionLocation = tempTransactionLocation.substring(0, tempTransactionLocation.lastIndexOf(47));
            }
            if (!this.componentsReferencingGlobalErrorHandler.contains(transactionLocation = tempTransactionLocation)) {
                return false;
            }
            String localFailingComponentLocation = ((MessagingException)((Object)exception)).getFailingComponent().getLocation().getLocation();
            String failingComponentHandledKey = transactionLocation + localFailingComponentLocation;
            FailingComponentHandle failingComponentHandle = null;
            if (this.failingComponentHandled.get(failingComponentHandledKey) != null) {
                if (this.getFlowStackElementLocation(event.getFlowCallStack().peek()).endsWith(localFailingComponentLocation)) {
                    this.failingComponentHandled.remove(failingComponentHandledKey);
                } else {
                    failingComponentHandle = this.failingComponentHandled.get(failingComponentHandledKey);
                }
            }
            if (failingComponentHandle != null) {
                failingComponentHandle.handle();
                if (failingComponentHandle.isHandled()) {
                    this.failingComponentHandled.remove(failingComponentHandledKey);
                    return true;
                }
                return false;
            }
            StringBuilder fullFailingComponentLocationUpToTxOwnerBuilder = new StringBuilder();
            for (FlowStackElement element : event.getFlowCallStack().getElements()) {
                String location = this.getFlowStackElementLocation(element);
                fullFailingComponentLocationUpToTxOwnerBuilder.insert(0, location + "/");
                if (!location.startsWith(transactionLocation)) continue;
                break;
            }
            String fullFailingComponentLocationUpToTxOwner = fullFailingComponentLocationUpToTxOwnerBuilder.toString();
            String transactionOwnerFlow = this.getFlow(transactionLocation);
            Set referencesContainingFailingComponentUpToTxOwner = this.componentsReferencingGlobalErrorHandler.stream().map(this::normalizeRef).filter(ref -> this.getFlow((String)ref).equals(this.getFlow(fullFailingComponentLocationUpToTxOwner)) ? fullFailingComponentLocationUpToTxOwner.contains((CharSequence)ref) : fullFailingComponentLocationUpToTxOwner.contains(this.normalizeFlowRef((String)ref))).filter(ref -> !this.getFlow((String)ref).equals(transactionOwnerFlow) || ref.startsWith(transactionLocation)).collect(Collectors.toSet());
            if (referencesContainingFailingComponentUpToTxOwner.size() > 1) {
                this.failingComponentHandled.put(failingComponentHandledKey, new FailingComponentHandle(referencesContainingFailingComponentUpToTxOwner.size()));
                return false;
            }
            return true;
        }
        return this.isOwnedTransactionByLocalErrorHandler(txAdapter);
    }

    private String getFlowStackElementLocation(FlowStackElement element) {
        return element.executingLocation().getLocation();
    }

    private String getFlow(String location) {
        return location.substring(0, location.indexOf(47) + 1);
    }

    private String normalizeRef(String reference) {
        return reference.endsWith("/") ? reference : reference + "/";
    }

    private String normalizeFlowRef(String reference) {
        return "/" + reference;
    }

    private boolean isOwnedTransactionByLocalErrorHandler(TransactionAdapter transaction) {
        if (!this.isLocalErrorHandlerLocation) {
            return this.sameRootContainerLocation(transaction);
        }
        String transactionLocation = transaction.getComponentLocation().get().getLocation();
        return this.errorHandlerLocation.equals(transactionLocation);
    }

    private boolean sameRootContainerLocation(TransactionAdapter transaction) {
        String transactionContainerName = transaction.getComponentLocation().get().getRootContainerName();
        return transactionContainerName.equals(this.getRootContainerLocation().getGlobalName());
    }

    private boolean inDefaultErrorHandler() {
        return this.getLocation() == null;
    }

    private boolean defaultErrorHandlerOwnsTransaction(TransactionAdapter transaction) {
        String transactionLocation = transaction.getComponentLocation().get().getLocation();
        if (this.flowLocation.isPresent()) {
            return transactionLocation.equals(this.flowLocation.get());
        }
        return this.sameRootContainerLocation(transaction);
    }

    protected ErrorTypeRepository getErrorTypeRepository() {
        return this.errorTypeRepository;
    }

    public void setFromGlobalErrorHandler(boolean fromGlobalErrorHandler) {
        this.fromGlobalErrorHandler = fromGlobalErrorHandler;
    }

    private final class OnErrorHandlerFluxObjectFactory
    implements Function<Function<Publisher<CoreEvent>, Publisher<CoreEvent>>, FluxSink<CoreEvent>>,
    Disposable {
        private final Optional<ProcessingStrategy> processingStrategy;
        private final Set<FluxSink<CoreEvent>> fluxSinks = Collections.newSetFromMap(new ConcurrentHashMap());

        public OnErrorHandlerFluxObjectFactory(Optional<ProcessingStrategy> processingStrategy) {
            this.processingStrategy = processingStrategy;
        }

        @Override
        public FluxSink<CoreEvent> apply(Function<Publisher<CoreEvent>, Publisher<CoreEvent>> publisherPostProcessor) {
            FluxSinkRecorder sinkRef = new FluxSinkRecorder();
            Flux onErrorFlux = sinkRef.flux().map(TemplateOnErrorHandler.this.beforeRouting());
            onErrorFlux = !TemplateOnErrorHandler.this.getMessageProcessors().isEmpty() ? onErrorFlux.transformDeferred(TemplateOnErrorHandler.this::route) : onErrorFlux.doOnNext(coreEvent -> TemplateOnErrorHandler.this.componentTracer.startSpan((Event)coreEvent));
            onErrorFlux = Flux.from(publisherPostProcessor.apply((Publisher<CoreEvent>)onErrorFlux.onErrorContinue(MessagingException.class, TemplateOnErrorHandler.this.onRoutingError()).map(TemplateOnErrorHandler.this.afterRouting()).doOnNext(result -> {
                ErrorHandlerContextManager.ErrorHandlerContext errorHandlerContext = ErrorHandlerContextManager.from(TemplateOnErrorHandler.this, result);
                TemplateOnErrorHandler.this.fireEndNotification(errorHandlerContext.getOriginalEvent(), (CoreEvent)result, (Throwable)((Object)errorHandlerContext.getException()));
            }).doOnNext(result -> {
                if (TemplateOnErrorHandler.this.getMessageProcessors().isEmpty()) {
                    TemplateOnErrorHandler.this.componentTracer.endCurrentSpan((Event)result);
                }
                ErrorHandlerContextManager.resolveHandling((FlowExceptionHandler)TemplateOnErrorHandler.this, result);
            }))).doAfterTerminate(() -> this.fluxSinks.remove(sinkRef.getFluxSink()));
            if (this.processingStrategy.isPresent() && !TemplateOnErrorHandler.this.fromGlobalErrorHandler) {
                String location = TemplateOnErrorHandler.this.getLocation() != null ? TemplateOnErrorHandler.this.getLocation().getLocation() : TemplateOnErrorHandler.this.flowLocation.map(Object::toString).orElse("");
                this.processingStrategy.get().registerInternalSink((Publisher<CoreEvent>)onErrorFlux, "error handler '" + location + "'");
            } else {
                onErrorFlux.subscribe();
            }
            FluxSink fluxSink = sinkRef.getFluxSink();
            this.fluxSinks.add(fluxSink);
            return fluxSink;
        }

        public void dispose() {
            this.fluxSinks.forEach(FluxSink::complete);
            this.fluxSinks.clear();
        }
    }

    private static class FailingComponentHandle {
        private final int timesToHandleBeforeReachingTxOwner;
        private int timesHandled;

        FailingComponentHandle(int timesToHandleBeforeReachingTxOwner) {
            this.timesToHandleBeforeReachingTxOwner = timesToHandleBeforeReachingTxOwner;
            this.timesHandled = 1;
        }

        boolean isHandled() {
            return this.timesHandled == this.timesToHandleBeforeReachingTxOwner;
        }

        void handle() {
            ++this.timesHandled;
        }
    }
}

