/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.tck;

import java.security.Security;
import java.util.HashSet;
import java.util.Set;
import org.junit.rules.ExternalResource;

public class BouncyCastleProviderCleaner
extends ExternalResource {
    private boolean initialized;
    private Set<String> providers;

    public BouncyCastleProviderCleaner() {
        HashSet<String> providers = new HashSet<String>();
        providers.add("BC");
        providers.add("BCJSSE");
        this.providers = providers;
    }

    protected void before() throws Throwable {
        if (this.initialized) {
            throw new IllegalArgumentException("System property was already initialized");
        }
        this.cleanUpProviders();
        this.initialized = true;
    }

    protected void cleanUpProviders() {
        for (String p : this.providers) {
            Security.removeProvider(p);
        }
    }

    protected void after() {
        if (!this.initialized) {
            throw new IllegalArgumentException("Bouncy castle provider was not initialized");
        }
        this.cleanUpProviders();
        this.initialized = false;
    }
}

