/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.utils;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.qameta.allure.Issue;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.service.http.netty.impl.util.RedirectHelper;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;

public class RedirectHelperTestCase
extends AbstractHttpTestCase {
    private HttpClientRequest mockRequest;
    private HttpClientResponse mockResponse;

    @Before
    public void setUp() {
        this.mockRequest = (HttpClientRequest)Mockito.mock(HttpClientRequest.class);
        this.mockResponse = (HttpClientResponse)Mockito.mock(HttpClientResponse.class);
    }

    private Map<String, String> getCookiesMap(RedirectHelper redirectHelper) throws Exception {
        Field field = redirectHelper.getClass().getDeclaredField("cookiesMap");
        field.setAccessible(true);
        return (Map)field.get(redirectHelper);
    }

    @Test
    @Issue(value="W-17405565")
    public void testHandleRedirectResponseWhenCookiesAreNotExpired() throws Exception {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add("Set-Cookie", (Object)"session=abcd1234; Path=/; Expires=Sun, 09 Jun 2030 10:18:14 GMT");
        headers.add("Set-Cookie", (Object)"user=testUser; Path=/; Max-Age=3600");
        Mockito.when((Object)this.mockResponse.responseHeaders()).thenReturn((Object)headers);
        Mockito.when((Object)this.mockResponse.status()).thenReturn((Object)HttpResponseStatus.FOUND);
        RedirectHelper redirectHelper = new RedirectHelper((HttpHeaders)new DefaultHttpHeaders());
        redirectHelper.handleRedirectResponse(this.mockResponse);
        Map<String, String> cookiesMap = this.getCookiesMap(redirectHelper);
        MatcherAssert.assertThat((Object)cookiesMap.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)cookiesMap.containsKey("session"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cookiesMap.get("session"), (Matcher)Matchers.is((Object)"abcd1234"));
        MatcherAssert.assertThat((Object)cookiesMap.containsKey("user"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cookiesMap.get("user"), (Matcher)Matchers.is((Object)"testUser"));
    }

    @Test
    @Issue(value="W-17405565")
    public void testHandleRedirectResponseWhenCookiesAreExpired() throws Exception {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add("Set-Cookie", (Object)"session=abcd1234; Path=/; Expires=Sun, 09 Jun 2024 10:18:14 GMT");
        headers.add("Set-Cookie", (Object)"user=testUser; Path=/; Max-Age=0");
        Mockito.when((Object)this.mockResponse.responseHeaders()).thenReturn((Object)headers);
        Mockito.when((Object)this.mockResponse.status()).thenReturn((Object)HttpResponseStatus.FOUND);
        RedirectHelper redirectHelper = new RedirectHelper((HttpHeaders)new DefaultHttpHeaders());
        redirectHelper.handleRedirectResponse(this.mockResponse);
        Map<String, String> cookiesMap = this.getCookiesMap(redirectHelper);
        MatcherAssert.assertThat((Object)cookiesMap.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    @Issue(value="W-17908187")
    public void testHandleRedirectResponse_WhenInitialCookieArePresent() throws Exception {
        AbstractMap.SimpleEntry<String, String> cookie = new AbstractMap.SimpleEntry<String, String>("user", "testUser");
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add("Set-Cookie", (Object)"session=abcd1234; Path=/; Expires=Sun, 09 Jun 2030 10:18:14 GMT");
        Mockito.when((Object)this.mockResponse.responseHeaders()).thenReturn((Object)headers);
        Mockito.when((Object)this.mockResponse.status()).thenReturn((Object)HttpResponseStatus.FOUND);
        RedirectHelper redirectHelper = new RedirectHelper(new DefaultHttpHeaders().add("Cookie", (Object)((String)cookie.getKey() + "=" + (String)cookie.getValue())));
        redirectHelper.handleRedirectResponse(this.mockResponse);
        Map<String, String> cookiesMap = this.getCookiesMap(redirectHelper);
        MatcherAssert.assertThat((Object)cookiesMap.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)cookiesMap.containsKey("session"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cookiesMap.get("session"), (Matcher)Matchers.is((Object)"abcd1234"));
        MatcherAssert.assertThat((Object)cookiesMap.containsKey("user"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cookiesMap.get("user"), (Matcher)Matchers.is((Object)"testUser"));
    }

    @Test
    @Issue(value="W-17405565")
    public void testAddCookie_ToRedirectedRequest_NoCookiesPresent() throws Exception {
        Mockito.when((Object)this.mockRequest.requestHeaders()).thenReturn((Object)new DefaultHttpHeaders());
        RedirectHelper redirectHelper = new RedirectHelper((HttpHeaders)new DefaultHttpHeaders());
        Map<String, String> cookiesMap = this.getCookiesMap(redirectHelper);
        MatcherAssert.assertThat((Object)cookiesMap.isEmpty(), (Matcher)Matchers.is((Object)true));
        redirectHelper.addCookiesToRedirectedRequest(this.mockRequest);
        ((HttpClientRequest)Mockito.verify((Object)this.mockRequest, (VerificationMode)Mockito.never())).addHeader((CharSequence)ArgumentMatchers.anyString(), (CharSequence)ArgumentMatchers.anyString());
    }

    @Test
    @Issue(value="W-17898850")
    public void shouldNotChangeMethodOnNewHelper() {
        RedirectHelper redirectHelper = new RedirectHelper((HttpHeaders)new DefaultHttpHeaders());
        MatcherAssert.assertThat((Object)redirectHelper.shouldChangeMethod(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    @Issue(value="W-17898850")
    public void shouldChangeMethodForEachStatus() {
        RedirectHelper redirectHelper = new RedirectHelper((HttpHeaders)new DefaultHttpHeaders());
        Mockito.when((Object)this.mockResponse.responseHeaders()).thenReturn((Object)new DefaultHttpHeaders());
        for (int statusCode = 300; statusCode <= 308; ++statusCode) {
            Mockito.when((Object)this.mockResponse.status()).thenReturn((Object)HttpResponseStatus.valueOf((int)statusCode));
            redirectHelper.handleRedirectResponse(this.mockResponse);
            boolean expected = statusCode == 302 || statusCode == 303;
            MatcherAssert.assertThat((Object)redirectHelper.shouldChangeMethod(), (Matcher)Matchers.is((Object)expected));
        }
    }
}

