/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.streaming;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;

public class BidirectionalByteBufferStream {
    private final Queue<ByteArrayInputStream> writtenData = new LinkedList<ByteArrayInputStream>();
    private int length = 0;

    public void write(byte[] buf, int off, int len) {
        this.writtenData.add(new ByteArrayInputStream(buf, off, len));
        this.length += len;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int bytesCurrentlyRead;
        int readInThisIteration;
        if (this.length == 0 || len == 0) {
            return 0;
        }
        ByteArrayInputStream head = this.writtenData.peek();
        if (head == null) {
            return 0;
        }
        for (bytesCurrentlyRead = 0; bytesCurrentlyRead < len && this.length > 0 && (readInThisIteration = this.readFromHead(buf, off + bytesCurrentlyRead, len - bytesCurrentlyRead)) != 0 && readInThisIteration != -1; bytesCurrentlyRead += readInThisIteration) {
        }
        return bytesCurrentlyRead;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    private int readFromHead(byte[] buf, int off, int len) throws IOException {
        ByteArrayInputStream head = this.writtenData.peek();
        if (head == null) {
            return 0;
        }
        int result = head.read(buf, off, len);
        this.length -= result;
        if (head.available() == 0) {
            head.close();
            this.writtenData.remove();
        }
        return result;
    }
}

