/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.classloader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.deployment.impl.internal.classloader.ClassLoaderNode;

public class DefaultClassLoaderNode
implements ClassLoaderNode {
    protected ArtifactClassLoader artifactClassLoader;
    protected List<ClassLoaderNode> delegateNodes;
    protected ClassLoaderNode parent;
    private String id;
    private boolean isMulePlugin = false;

    @Override
    public ArtifactClassLoader getArtifactClassLoader() {
        return this.artifactClassLoader;
    }

    @Override
    public boolean isMulePlugin() {
        return this.isMulePlugin;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<ClassLoaderNode> getDelegateNodes() {
        return this.delegateNodes;
    }

    public void setParent(ClassLoaderNode parent) {
        this.parent = parent;
    }

    @Override
    public Optional<ClassLoaderNode> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public static DefaultClassLoaderNodeBuilder builder() {
        return new DefaultClassLoaderNodeBuilder();
    }

    public String toString() {
        Stack<DefaultClassLoaderNode> classLoaderNodes = new Stack<DefaultClassLoaderNode>();
        ClassLoaderNode currentNode = this;
        int maximumIdLength = 0;
        do {
            classLoaderNodes.push((DefaultClassLoaderNode)currentNode);
            maximumIdLength = Math.max(maximumIdLength, currentNode.getId().length());
            for (ClassLoaderNode childNode : currentNode.getDelegateNodes()) {
                maximumIdLength = Math.max(maximumIdLength, childNode.getId().length());
            }
        } while ((currentNode = (ClassLoaderNode)currentNode.getParent().orElse(null)) != null);
        StringBuilder stringBuilder = new StringBuilder();
        int frameSize = maximumIdLength + 4;
        AtomicBoolean isFirst = new AtomicBoolean(true);
        do {
            ClassLoaderNode classLoaderNode = (ClassLoaderNode)classLoaderNodes.pop();
            boolean isLastNode = classLoaderNodes.empty();
            if (!isFirst.get()) {
                stringBuilder.append(StringUtils.center((String)"^", (int)frameSize)).append(System.lineSeparator());
                stringBuilder.append(StringUtils.center((String)"|", (int)frameSize)).append(System.lineSeparator());
            }
            isFirst.set(false);
            this.printNodeFrame(stringBuilder, frameSize, classLoaderNode, false, false);
            for (int i = 0; i < classLoaderNode.getDelegateNodes().size(); ++i) {
                ClassLoaderNode delegateNode = classLoaderNode.getDelegateNodes().get(i);
                stringBuilder.append(StringUtils.center((String)"|", (int)frameSize)).append(System.lineSeparator());
                boolean isLastItem = i == classLoaderNode.getDelegateNodes().size() - 1;
                this.printNodeFrame(stringBuilder, frameSize, delegateNode, true, isLastNode && isLastItem);
            }
        } while (!classLoaderNodes.empty());
        return stringBuilder.toString();
    }

    @Override
    public ClassLoaderNode findClassLoaderNode(ArtifactClassLoader artifactClassLoader) {
        if (this.getArtifactClassLoader().equals(artifactClassLoader)) {
            return this;
        }
        for (ClassLoaderNode classLoaderNode : this.getDelegateNodes()) {
            if (!classLoaderNode.getArtifactClassLoader().equals(artifactClassLoader)) continue;
            return classLoaderNode;
        }
        return this.getParent().get().findClassLoaderNode(artifactClassLoader);
    }

    private void printNodeFrame(StringBuilder stringBuilder, int frameSize, ClassLoaderNode classLoaderNode, boolean includeDelegateLines, boolean doNotAddHierarchyLines) {
        if (includeDelegateLines) {
            stringBuilder.append(StringUtils.repeat((String)" ", (int)(frameSize / 2))).append(StringUtils.repeat((String)"-", (int)(frameSize / 2))).append("> ");
        }
        stringBuilder.append(StringUtils.repeat((String)"-", (int)frameSize)).append(System.lineSeparator());
        if (includeDelegateLines) {
            stringBuilder.append(StringUtils.center((String)(doNotAddHierarchyLines ? " " : "|"), (int)frameSize)).append(StringUtils.repeat((String)" ", (int)2));
        }
        stringBuilder.append("|").append(StringUtils.center((String)classLoaderNode.getId(), (int)(frameSize - 2))).append("|").append(System.lineSeparator());
        if (includeDelegateLines) {
            stringBuilder.append(StringUtils.center((String)(doNotAddHierarchyLines ? " " : "|"), (int)frameSize)).append(StringUtils.repeat((String)" ", (int)2));
        }
        stringBuilder.append(StringUtils.repeat((String)"-", (int)frameSize)).append(System.lineSeparator());
    }

    @Override
    public List<ClassLoaderNode> findPossibleResourceOwners(String resourceName) {
        ArrayList<ClassLoaderNode> resourceOwners = new ArrayList<ClassLoaderNode>();
        if (!(this.getArtifactClassLoader() instanceof RegionClassLoader) && this.getArtifactClassLoader().findLocalResource(resourceName) != null) {
            resourceOwners.add(this);
        }
        for (ClassLoaderNode classLoaderNode2 : this.getDelegateNodes()) {
            if (classLoaderNode2.isMulePlugin() || classLoaderNode2.getArtifactClassLoader().findInternalResource(resourceName) == null) continue;
            resourceOwners.add(classLoaderNode2);
        }
        this.getParent().map(classLoaderNode -> resourceOwners.addAll(classLoaderNode.findPossibleResourceOwners(resourceName)));
        return resourceOwners;
    }

    @Override
    public List<ClassLoaderNode> findPossibleClassOwners(String className) {
        ArrayList<ClassLoaderNode> resourceOwners = new ArrayList<ClassLoaderNode>();
        try {
            if (!(this.getArtifactClassLoader() instanceof RegionClassLoader)) {
                this.getArtifactClassLoader().loadInternalClass(className);
                resourceOwners.add(this);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (ClassLoaderNode classLoaderNode2 : this.getDelegateNodes()) {
            try {
                if (classLoaderNode2.isMulePlugin() || classLoaderNode2.getArtifactClassLoader().loadInternalClass(className) == null) continue;
                resourceOwners.add(classLoaderNode2);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        this.getParent().map(classLoaderNode -> resourceOwners.addAll(classLoaderNode.findPossibleClassOwners(className)));
        return resourceOwners;
    }

    public static final class DefaultClassLoaderNodeBuilder {
        protected ArtifactClassLoader artifactClassLoader;
        protected List<ClassLoaderNode> delegateNodes = Collections.emptyList();
        protected ClassLoaderNode parent;
        private String id;
        private boolean isMulePlugin = false;

        private DefaultClassLoaderNodeBuilder() {
        }

        public DefaultClassLoaderNodeBuilder withArtifactClassLoader(ArtifactClassLoader artifactClassLoader) {
            this.artifactClassLoader = artifactClassLoader;
            return this;
        }

        public DefaultClassLoaderNodeBuilder withDelegateNodes(List<ClassLoaderNode> delegateNodes) {
            this.delegateNodes = delegateNodes;
            return this;
        }

        public DefaultClassLoaderNodeBuilder withParent(ClassLoaderNode parent) {
            this.parent = parent;
            return this;
        }

        public DefaultClassLoaderNodeBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public DefaultClassLoaderNodeBuilder withIsMulePlugin(boolean isMulePlugin) {
            this.isMulePlugin = isMulePlugin;
            return this;
        }

        public DefaultClassLoaderNode build() {
            DefaultClassLoaderNode defaultClassLoaderNode = new DefaultClassLoaderNode();
            defaultClassLoaderNode.parent = this.parent;
            defaultClassLoaderNode.delegateNodes = this.delegateNodes;
            defaultClassLoaderNode.artifactClassLoader = this.artifactClassLoader;
            defaultClassLoaderNode.id = this.id;
            defaultClassLoaderNode.isMulePlugin = this.isMulePlugin;
            for (ClassLoaderNode delegateNode : this.delegateNodes) {
                if (!(delegateNode instanceof DefaultClassLoaderNode)) continue;
                ((DefaultClassLoaderNode)delegateNode).parent = defaultClassLoaderNode;
            }
            return defaultClassLoaderNode;
        }
    }
}

