/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.util.attribute.AttributeEvaluator;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedValueResolver;

public class ExpressionValueResolver<T>
implements ExpressionBasedValueResolver<T>,
Initialisable {
    @Inject
    private ExtendedExpressionManager extendedExpressionManager;
    final AttributeEvaluator evaluator;
    private final String expression;

    public ExpressionValueResolver(String expression, DataType expectedDataType) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)expression) ? 1 : 0) != 0, (String)"Expression cannot be blank or null");
        this.expression = expression;
        this.evaluator = new AttributeEvaluator(expression, expectedDataType);
    }

    public ExpressionValueResolver(String expression) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)expression) ? 1 : 0) != 0, (String)"Expression cannot be blank or null");
        this.expression = expression;
        this.evaluator = new AttributeEvaluator(expression);
    }

    void setExtendedExpressionManager(ExtendedExpressionManager extendedExpressionManager) {
        this.extendedExpressionManager = extendedExpressionManager;
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.extendedExpressionManager);
        this.getEvaluator().initialize(this.extendedExpressionManager);
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        TypedValue typedValue = this.resolveTypedValue(context);
        Object value = typedValue.getValue();
        if (ClassUtils.isInstance(ValueResolver.class, (Object)value)) {
            value = ((ValueResolver)value).resolve(context);
        }
        return (T)value;
    }

    protected <V> TypedValue<V> resolveTypedValue(ValueResolvingContext context) {
        if (context.getSession() != null) {
            return this.evaluator.resolveTypedValue(context.getSession());
        }
        return this.evaluator.resolveTypedValue(context.getEvent());
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    private AttributeEvaluator getEvaluator() {
        return this.evaluator;
    }
}

