/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.netty.handler.ssl.SslContext;
import io.qameta.allure.Issue;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttp1ResponseReadyCallback;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.test.netty.tck.ExecutorRule;
import org.mule.service.http.test.netty.utils.TestHttp2RequestHandler;
import org.mule.service.http.test.netty.utils.TestUtils;
import org.mule.service.http.test.netty.utils.client.TestSSLNettyClient;
import org.mule.tck.junit4.rule.DynamicPort;

public class NettyHttpServerHeaderLimitTestCase {
    @ClassRule
    public static ExecutorRule executorRule = new ExecutorRule();
    private HttpServer server;
    private static final int MAX_NUM_HEADERS_DEFAULT = 100;
    private static final String MAX_SERVER_REQUEST_HEADERS_KEY = "mule.http.MAX_SERVER_REQUEST_HEADERS";
    private static final String MAX_SERVER_RESPONSE_HEADERS_KEY = "mule.http.MAX_SERVER_RESPONSE_HEADERS";
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public TestSSLNettyClient testClient = new TestSSLNettyClient("localhost", this.serverPort.getNumber(), executorRule.getExecutor());

    @Before
    public void setUp() throws Exception {
        HttpListenerRegistry listenerRegistry = new HttpListenerRegistry();
        SslContext serverSslContext = TestUtils.createServerSslContext();
        this.server = NettyHttpServer.builder().withName("test-server").withServerAddress(new InetSocketAddress(this.serverPort.getNumber())).withHttpListenerRegistry(listenerRegistry).withSslContext(serverSslContext).withShutdownTimeout(() -> 5000L).withClientChannelHandler(new AcceptedConnectionChannelInitializer(listenerRegistry, "test-server", true, 30000, 10000L, serverSslContext, (ExecutorService)executorRule.getExecutor())).build();
        this.server.start();
        this.server.addRequestHandler("/path", (RequestHandler)new TestHttp2RequestHandler());
        this.server.addRequestHandler(Collections.singleton("GET"), "/only-get", (RequestHandler)new TestHttp2RequestHandler());
    }

    @After
    public void tearDown() {
        this.server.stop().dispose();
    }

    @Issue(value="W-15642768")
    @Test
    public void testMaxServerRequestHeaders() throws Exception {
        MatcherAssert.assertThat((Object)HttpListenerRegistry.getMaxServerRequestHeaders(), (Matcher)Matchers.equalTo((Object)100));
        System.setProperty(MAX_SERVER_REQUEST_HEADERS_KEY, "5");
        HttpListenerRegistry.refreshMaxServerRequestHeaders();
        MultiMap.StringMultiMap headers = new MultiMap.StringMultiMap();
        headers.put((Object)"testheader1", (Object)"testvalue1");
        headers.put((Object)"testheader2", (Object)"testvalue2");
        headers.put((Object)"testheader3", (Object)"testvalue3");
        headers.put((Object)"testheader4", (Object)"testvalue4");
        headers.put((Object)"testheader5", (Object)"testvalue5");
        headers.put((Object)"testheader6", (Object)"testvalue6");
        HttpResponse response = this.testClient.sendGet("/path", (MultiMap<String, String>)headers);
        String responseAsString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)HttpListenerRegistry.getMaxServerRequestHeaders(), (Matcher)Matchers.equalTo((Object)5));
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.REQUEST_TOO_LONG.getStatusCode()));
        MatcherAssert.assertThat((Object)responseAsString, (Matcher)Matchers.containsString((String)"Request entity too large"));
        System.clearProperty(MAX_SERVER_REQUEST_HEADERS_KEY);
        HttpListenerRegistry.refreshMaxServerRequestHeaders();
    }

    @Issue(value="W-15642768")
    @Test
    public void testMaxServerResponseHeaders() throws Exception {
        MatcherAssert.assertThat((Object)NettyHttp1ResponseReadyCallback.getMaxServerResponseHeaders(), (Matcher)Matchers.equalTo((Object)100));
        System.setProperty(MAX_SERVER_RESPONSE_HEADERS_KEY, "1");
        NettyHttp1ResponseReadyCallback.refreshMaxServerResponseHeaders();
        MatcherAssert.assertThat((Object)NettyHttp1ResponseReadyCallback.getMaxServerResponseHeaders(), (Matcher)Matchers.equalTo((Object)1));
        try {
            this.testClient.sendGet("/path");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.containsString((String)"Exceeded max server response headers limit"));
        }
        System.clearProperty(MAX_SERVER_RESPONSE_HEADERS_KEY);
        NettyHttp1ResponseReadyCallback.refreshMaxServerResponseHeaders();
    }
}

