/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.api.util.CaseInsensitiveHashMap;
import org.mule.runtime.core.internal.event.InternalEvent;
import org.mule.runtime.core.internal.message.EventInternalContext;
import org.mule.runtime.core.internal.util.message.ItemSequenceInfoUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.event.context.FlowProcessMediatorContext;
import org.slf4j.MDC;

public class DefaultEventBuilder
implements InternalEvent.Builder {
    private BaseEventContext context;
    private Function<EventContext, Message> messageFactory;
    private CaseInsensitiveHashMap<String, TypedValue<?>> flowVariables;
    private CaseInsensitiveHashMap<String, TypedValue<?>> originalVars;
    private boolean varsModified = false;
    private CaseInsensitiveHashMap<String, TypedValue<?>> parameters;
    private final CaseInsensitiveHashMap<String, TypedValue<?>> originalParameters;
    private boolean parametersModified = false;
    private CaseInsensitiveHashMap<String, String> loggingVariables;
    private Map<String, Object> internalParameters;
    private Error error;
    private Optional<ItemSequenceInfo> itemSequenceInfo = Optional.empty();
    private String legacyCorrelationId;
    private SecurityContext securityContext;
    private FlowProcessMediatorContext flowProcessMediatorContext;
    private EventInternalContext sdkInternalContext;
    private EventInternalContext foreachInternalContext;
    private EventInternalContext sourcePolicyContext;
    private EventInternalContext operationPolicyContext;
    private InternalEvent originalEvent;
    private boolean modified;
    private boolean internalParametersInitialized = false;
    private boolean notificationsEnabled = true;

    public DefaultEventBuilder(BaseEventContext messageContext) {
        this.context = messageContext;
        this.originalVars = CaseInsensitiveHashMap.emptyCaseInsensitiveMap();
        this.originalParameters = CaseInsensitiveHashMap.emptyCaseInsensitiveMap();
        this.internalParameters = new SmallMap();
        this.internalParametersInitialized = true;
    }

    public DefaultEventBuilder(InternalEvent event) {
        this.context = event.getContext();
        this.originalEvent = event;
        this.messageFactory = e -> event.getMessage();
        this.itemSequenceInfo = event.getItemSequenceInfo();
        this.legacyCorrelationId = event.getLegacyCorrelationId();
        this.securityContext = event.getSecurityContext();
        this.error = event.getError().orElse(null);
        this.notificationsEnabled = event.isNotificationsEnabled();
        this.originalVars = (CaseInsensitiveHashMap)event.getVariables();
        this.originalParameters = (CaseInsensitiveHashMap)event.getParameters();
        this.loggingVariables = event.getLoggingVariables().orElse(null);
        if (this.loggingVariables != null) {
            CaseInsensitiveHashMap<String, String> loggingVariablesCopyMap = new CaseInsensitiveHashMap<String, String>();
            loggingVariablesCopyMap.putAll(this.loggingVariables);
            this.loggingVariables = loggingVariablesCopyMap;
        }
        this.internalParameters = event.getInternalParameters();
        this.flowProcessMediatorContext = EventInternalContext.copyOf(event.getFlowProcessMediatorContext());
        this.foreachInternalContext = EventInternalContext.copyOf(event.getForeachInternalContext());
        this.sdkInternalContext = EventInternalContext.copyOf(event.getSdkInternalContext());
        this.sourcePolicyContext = EventInternalContext.copyOf(event.getSourcePolicyContext());
        this.operationPolicyContext = EventInternalContext.copyOf(event.getOperationPolicyContext());
    }

    public DefaultEventBuilder(BaseEventContext messageContext, InternalEvent event) {
        this(event);
        this.context = messageContext;
        this.modified = true;
    }

    @Override
    public DefaultEventBuilder message(Message message) {
        Objects.requireNonNull(message);
        this.messageFactory = e -> message;
        this.modified = true;
        return this;
    }

    @Override
    public InternalEvent.Builder message(Function<EventContext, Message> messageFactory) {
        Objects.requireNonNull(messageFactory);
        this.messageFactory = messageFactory;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder variables(Map<String, ?> flowVariables) {
        this.initVariables();
        this.copyFromTo(flowVariables, this.flowVariables);
        this.varsModified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder variablesTyped(Map<String, TypedValue<?>> variables) {
        if (!(variables instanceof CaseInsensitiveHashMap)) {
            return this.variables((Map)variables);
        }
        if (this.varsModified) {
            this.flowVariables.clear();
        }
        this.originalVars = (CaseInsensitiveHashMap)variables;
        this.varsModified = false;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder addVariable(String key, Object value) {
        if (value instanceof TypedValue) {
            return (DefaultEventBuilder)this.addVariable(key, (TypedValue)value);
        }
        this.initVariables();
        this.flowVariables.put(key, new TypedValue(value, DataType.fromObject((Object)value)));
        this.varsModified = true;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder addVariable(String key, Object value, DataType dataType) {
        this.initVariables();
        this.flowVariables.put(key, new TypedValue(value, dataType));
        this.varsModified = true;
        this.modified = true;
        return this;
    }

    @Override
    public CoreEvent.Builder addVariable(String key, TypedValue<?> value) {
        this.initVariables();
        this.flowVariables.put(key, value);
        this.varsModified = true;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder removeVariable(String key) {
        this.initVariables();
        this.modified = this.flowVariables.remove(key) != null || this.modified;
        this.varsModified = this.varsModified || this.modified;
        return this;
    }

    @Override
    public CoreEvent.Builder parameters(Map<String, ?> parameters) {
        this.parameters = new CaseInsensitiveHashMap();
        this.copyFromTo(parameters, this.parameters);
        this.parametersModified = true;
        return this;
    }

    @Override
    public CoreEvent.Builder clearParameters() {
        this.parameters = CaseInsensitiveHashMap.emptyCaseInsensitiveMap();
        this.parametersModified = true;
        this.modified = true;
        return this;
    }

    @Override
    public PrivilegedEvent.Builder addLoggingVariable(String key, String value) {
        if (this.loggingVariables == null) {
            this.loggingVariables = new CaseInsensitiveHashMap();
        }
        this.loggingVariables.put(key, value);
        this.modified = true;
        return this;
    }

    @Override
    public PrivilegedEvent.Builder removeLoggingVariable(String key) {
        if (this.loggingVariables == null) {
            return this;
        }
        if (this.loggingVariables.remove(key) == null) {
            return this;
        }
        MDC.remove((String)key);
        this.modified = true;
        return this;
    }

    @Override
    public PrivilegedEvent.Builder clearLoggingVariables() {
        if (this.loggingVariables == null) {
            return this;
        }
        if (this.loggingVariables.isEmpty()) {
            return this;
        }
        this.loggingVariables.forEach((k, v) -> MDC.remove((String)k));
        this.loggingVariables.clear();
        this.modified = true;
        return this;
    }

    @Override
    public InternalEvent.Builder clearVariables() {
        if (this.flowVariables != null && !this.flowVariables.isEmpty() || !this.originalVars.isEmpty()) {
            this.varsModified = true;
            this.modified = true;
            this.flowVariables = CaseInsensitiveHashMap.basedOn(new SmallMap());
        }
        return this;
    }

    @Override
    public DefaultEventBuilder internalParameters(Map<String, ?> internalParameters) {
        this.initInternalParameters();
        this.internalParameters.clear();
        this.internalParameters.putAll(internalParameters);
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder addInternalParameter(String key, Object value) {
        this.initInternalParameters();
        this.internalParameters.put(key, value);
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder removeInternalParameter(String key) {
        this.initInternalParameters();
        this.modified = this.internalParameters.remove(key) != null || this.modified;
        return this;
    }

    @Override
    public DefaultEventBuilder correlationId(String correlationId) {
        this.legacyCorrelationId = correlationId;
        this.modified = true;
        return this;
    }

    @Override
    @Deprecated
    public DefaultEventBuilder groupCorrelation(Optional<GroupCorrelation> correlation) {
        return this.itemSequenceInfo((Optional)Optional.ofNullable(ItemSequenceInfoUtils.fromGroupCorrelation(correlation.orElse(null))));
    }

    @Override
    public DefaultEventBuilder itemSequenceInfo(Optional<ItemSequenceInfo> itemSequenceInfo) {
        this.itemSequenceInfo = itemSequenceInfo;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder error(Error error) {
        this.error = error;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder securityContext(SecurityContext securityContext) {
        SecurityContext originalValue = this.securityContext;
        this.securityContext = securityContext;
        this.modified = this.modified || originalValue != securityContext;
        return this;
    }

    @Override
    public DefaultEventBuilder disableNotifications() {
        this.notificationsEnabled = false;
        this.modified = true;
        return this;
    }

    @Override
    public InternalEvent build() {
        if (this.originalEvent != null && !this.modified) {
            return this.originalEvent;
        }
        return new InternalEventImplementation(this.context, Objects.requireNonNull(this.messageFactory.apply(this.context)), this.varsModified ? this.flowVariables : this.originalVars, this.parametersModified ? this.parameters : this.originalParameters, this.loggingVariables, this.internalParameters, this.securityContext, this.itemSequenceInfo, this.flowProcessMediatorContext, this.sdkInternalContext, this.foreachInternalContext, this.sourcePolicyContext, this.operationPolicyContext, this.error, this.legacyCorrelationId, this.notificationsEnabled);
    }

    protected void initVariables() {
        if (!this.varsModified && this.flowVariables == null) {
            this.flowVariables = this.originalVars.copy();
        }
    }

    protected void initInternalParameters() {
        if (!this.internalParametersInitialized) {
            this.internalParameters = SmallMap.copy(this.internalParameters);
            this.internalParametersInitialized = true;
        }
    }

    private void copyFromTo(Map<String, ?> source, Map<String, TypedValue<?>> target) {
        target.clear();
        for (Map.Entry<String, ?> entry : source.entrySet()) {
            if (entry.getValue() instanceof TypedValue) {
                target.put(entry.getKey(), (TypedValue)entry.getValue());
                continue;
            }
            target.put(entry.getKey(), new TypedValue(entry.getValue(), DataType.fromObject(entry.getValue())));
        }
        this.modified = true;
    }

    public static class InternalEventImplementation
    implements InternalEvent {
        private static final long serialVersionUID = 1L;
        private final BaseEventContext context;
        private Message message;
        private final MuleSession session = null;
        private final SecurityContext securityContext;
        private final boolean notificationsEnabled;
        private final CaseInsensitiveHashMap<String, TypedValue<?>> variables;
        private final CaseInsensitiveHashMap<String, TypedValue<?>> parameters;
        private final CaseInsensitiveHashMap<String, String> loggingVariables;
        private final String legacyCorrelationId;
        private final Error error;
        private final ItemSequenceInfo itemSequenceInfo;
        private transient Map<String, ?> internalParameters;
        private transient FlowProcessMediatorContext flowProcessMediatorContext;
        private transient EventInternalContext sdkInternalContext;
        private transient EventInternalContext foreachInternalContext;
        private transient EventInternalContext sourcePolicyContext;
        private transient EventInternalContext operationPolicyContext;
        private volatile transient BindingContext bindingContextBuilder;

        private InternalEventImplementation() {
            this.context = null;
            this.securityContext = null;
            this.notificationsEnabled = false;
            this.variables = null;
            this.parameters = null;
            this.loggingVariables = null;
            this.legacyCorrelationId = null;
            this.error = null;
            this.itemSequenceInfo = null;
            this.flowProcessMediatorContext = null;
            this.sdkInternalContext = null;
            this.foreachInternalContext = null;
            this.sourcePolicyContext = null;
            this.operationPolicyContext = null;
            this.internalParameters = new SmallMap();
        }

        private InternalEventImplementation(BaseEventContext context, Message message, CaseInsensitiveHashMap<String, TypedValue<?>> variables, CaseInsensitiveHashMap<String, TypedValue<?>> parameters, CaseInsensitiveHashMap<String, String> loggingVariables, Map<String, ?> internalParameters, SecurityContext securityContext, Optional<ItemSequenceInfo> itemSequenceInfo, FlowProcessMediatorContext flowProcessMediatorContext, EventInternalContext sdkInternalContext, EventInternalContext foreachInternalContext, EventInternalContext sourcePolicyContext, EventInternalContext operationPolicyContext, Error error, String legacyCorrelationId, boolean notificationsEnabled) {
            this.context = context;
            this.loggingVariables = loggingVariables;
            this.securityContext = securityContext;
            this.message = message;
            this.variables = variables.toImmutableCaseInsensitiveMap();
            this.parameters = parameters.toImmutableCaseInsensitiveMap();
            this.internalParameters = internalParameters;
            this.itemSequenceInfo = itemSequenceInfo.orElse(null);
            this.flowProcessMediatorContext = flowProcessMediatorContext;
            this.sdkInternalContext = sdkInternalContext;
            this.foreachInternalContext = foreachInternalContext;
            this.sourcePolicyContext = sourcePolicyContext;
            this.operationPolicyContext = operationPolicyContext;
            this.error = error;
            this.legacyCorrelationId = legacyCorrelationId;
            this.notificationsEnabled = notificationsEnabled;
        }

        private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
            is.defaultReadObject();
            this.internalParameters = new SmallMap();
        }

        @Override
        public BaseEventContext getContext() {
            return this.context;
        }

        public Message getMessage() {
            return this.message;
        }

        public Optional<Authentication> getAuthentication() {
            if (this.securityContext == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.securityContext.getAuthentication());
        }

        public Optional<Error> getError() {
            return Optional.ofNullable(this.error);
        }

        public String toString() {
            return "DefaultMuleEvent{" + System.lineSeparator() + "  context=" + String.valueOf(this.context) + System.lineSeparator() + "  message=" + String.valueOf(this.message) + System.lineSeparator() + "  variables=" + String.valueOf(this.variables) + System.lineSeparator() + "  error=" + String.valueOf(this.error) + System.lineSeparator() + "}";
        }

        @Override
        public Optional<Map<String, String>> getLoggingVariables() {
            return Optional.ofNullable(this.loggingVariables);
        }

        public Map<String, TypedValue<?>> getVariables() {
            return this.variables;
        }

        public Map<String, TypedValue<?>> getParameters() {
            return this.parameters;
        }

        @Override
        public boolean isNotificationsEnabled() {
            return this.notificationsEnabled;
        }

        @Override
        public FlowCallStack getFlowCallStack() {
            return this.context.getFlowCallStack();
        }

        @Override
        public SecurityContext getSecurityContext() {
            return this.securityContext;
        }

        @Override
        public Map<String, ?> getInternalParameters() {
            return SmallMap.unmodifiable(this.internalParameters);
        }

        @Override
        public <T> T getInternalParameter(String key) {
            return (T)this.internalParameters.get(key);
        }

        @Override
        public Optional<GroupCorrelation> getGroupCorrelation() {
            return Optional.ofNullable(ItemSequenceInfoUtils.toGroupCorrelation(this.itemSequenceInfo));
        }

        public Optional<ItemSequenceInfo> getItemSequenceInfo() {
            return Optional.ofNullable(this.itemSequenceInfo);
        }

        @Override
        public FlowProcessMediatorContext getFlowProcessMediatorContext() {
            return this.flowProcessMediatorContext;
        }

        @Override
        public void setFlowProcessMediatorContext(FlowProcessMediatorContext flowProcessMediatorContext) {
            if (this.flowProcessMediatorContext != null) {
                throw new IllegalStateException("flowProcessMediatorContext was already set.");
            }
            this.flowProcessMediatorContext = flowProcessMediatorContext;
        }

        public EventInternalContext getSdkInternalContext() {
            return this.sdkInternalContext;
        }

        public void setSdkInternalContext(EventInternalContext sdkInternalContext) {
            this.sdkInternalContext = sdkInternalContext;
        }

        public EventInternalContext getForeachInternalContext() {
            return this.foreachInternalContext;
        }

        public void setForeachInternalContext(EventInternalContext foreachInternalContext) {
            this.foreachInternalContext = foreachInternalContext;
        }

        public EventInternalContext getSourcePolicyContext() {
            return this.sourcePolicyContext;
        }

        public void setSourcePolicyContext(EventInternalContext sourcePolicyContext) {
            this.sourcePolicyContext = sourcePolicyContext;
        }

        public EventInternalContext getOperationPolicyContext() {
            return this.operationPolicyContext;
        }

        public void setOperationPolicyContext(EventInternalContext operationPolicyContext) {
            this.operationPolicyContext = operationPolicyContext;
        }

        public String getCorrelationId() {
            return this.legacyCorrelationId != null ? this.legacyCorrelationId : this.getContext().getCorrelationId();
        }

        @Override
        @Deprecated
        public String getLegacyCorrelationId() {
            return this.legacyCorrelationId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BindingContext asBindingContext() {
            if (this.bindingContextBuilder == null) {
                InternalEventImplementation internalEventImplementation = this;
                synchronized (internalEventImplementation) {
                    if (this.bindingContextBuilder == null) {
                        this.bindingContextBuilder = BindingContextUtils.addEventBindings((Event)this, (BindingContext)BindingContextUtils.NULL_BINDING_CONTEXT);
                    }
                }
            }
            return this.bindingContextBuilder;
        }
    }
}

