/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.RouterOutputMetadataContext;
import org.mule.runtime.api.metadata.ScopeOutputMetadataContext;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.retry.ReconnectionConfig;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.runtime.config.ConfigurationProviderFactory;
import org.mule.runtime.module.extension.api.runtime.config.ExtensionDesignTimeResolversFactory;
import org.mule.runtime.module.extension.api.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.api.tooling.metadata.MetadataMediator;
import org.mule.runtime.module.extension.api.tooling.sampledata.SampleDataProviderMediator;
import org.mule.runtime.module.extension.api.tooling.valueprovider.ValueProviderMediator;
import org.mule.runtime.module.extension.internal.data.sample.DefaultSampleDataProviderMediator;
import org.mule.runtime.module.extension.internal.metadata.DefaultMetadataContext;
import org.mule.runtime.module.extension.internal.metadata.DefaultMetadataMediator;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationCreationUtils;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.config.DesignTimeParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ConnectionProviderSettings;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.value.DefaultValueProviderMediator;

public class DefaultExtensionDesignTimeResolversFactory
implements ExtensionDesignTimeResolversFactory {
    private static final String CHILD_ELEMENT_KEY_PREFIX = "<<";
    private static final String CHILD_ELEMENT_KEY_SUFFIX = ">>";
    @Inject
    private MuleContext muleContext;
    @Inject
    private ReflectionCache reflectionCache;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private Registry registry;

    @Override
    public <C> ConnectionProviderValueResolver<C> createConnectionProviderResolver(ConnectionProviderModel connectionProviderModel, ComponentParameterization componentParameterization, PoolingProfile poolingProfile, ReconnectionConfig reconnectionConfig, ExtensionModel extensionModel, ConfigurationProperties configurationProperties, String parametersOwner, DslSyntaxResolver dslSyntaxResolver) throws MuleException {
        ConnectionProviderSettings settings = new ConnectionProviderSettings(connectionProviderModel, componentParameterization, poolingProfile, reconnectionConfig, this.lookup(AuthorizationCodeOAuthHandler.class), this.lookup(ClientCredentialsOAuthHandler.class), this.lookup(PlatformManagedOAuthHandler.class));
        return ConfigurationCreationUtils.createConnectionProviderResolver(extensionModel, settings, configurationProperties, this.expressionManager, this.reflectionCache, parametersOwner, dslSyntaxResolver, this.muleContext);
    }

    private <T> T lookup(Class<T> clazz) {
        return this.registry.lookupByType(clazz).orElse(null);
    }

    @Override
    public ConfigurationProvider createConfigurationProvider(ExtensionModel extensionModel, ConfigurationModel configurationModel, String configName, Map<String, Object> parameters, Optional<ExpirationPolicy> expirationPolicy, Optional<ConnectionProviderValueResolver> connectionProviderResolver, ConfigurationProviderFactory configurationProviderFactory, String parametersOwner, DslSyntaxResolver dslSyntaxResolver, ClassLoader extensionClassLoader) {
        return ConfigurationCreationUtils.createConfigurationProvider(extensionModel, configurationModel, configName, parameters, expirationPolicy, connectionProviderResolver, configurationProviderFactory, this.expressionManager, this.reflectionCache, parametersOwner, dslSyntaxResolver, extensionClassLoader, this.muleContext);
    }

    @Override
    public <C> ConnectionProvider<C> createConnectionProvider(ExtensionModel extensionModel, ConnectionProviderModel connectionProviderModel, Map<String, Object> parameters, String parametersOwner) throws MuleException {
        ResolverSet resolverSet = this.createParametersResolverSetFromValues(parameters, (ParameterizedModel)connectionProviderModel);
        resolverSet.initialise();
        ConnectionProviderResolver connectionProviderResolver = new ConnectionProviderResolver(new DefaultConnectionProviderObjectBuilder(connectionProviderModel, resolverSet, extensionModel, this.expressionManager, this.muleContext), resolverSet, this.muleContext);
        connectionProviderResolver.setOwnerConfigName(parametersOwner);
        ConnectionProvider connectionProvider = (ConnectionProvider)connectionProviderResolver.getObjectBuilder().get().build(this.resolveResolverSet(this.muleContext, resolverSet)).getFirst();
        return connectionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolverSetResult resolveResolverSet(MuleContext muleContext, ResolverSet resolverSet) throws MuleException {
        ResolverSetResult result;
        CoreEvent initializerEvent = CoreEvent.nullEvent();
        try {
            result = resolverSet.resolve(ValueResolvingContext.builder(initializerEvent).build());
        }
        finally {
            ((BaseEventContext)initializerEvent.getContext()).success();
        }
        return result;
    }

    @Override
    public ParameterValueResolver createParameterValueResolver(ComponentParameterization<?> actingParameter, ParameterizedModel parameterizedModel) throws MuleException {
        return this.createParameterValueResolver(actingParameter, parameterizedModel, () -> Optional.empty());
    }

    @Override
    public ParameterValueResolver createParameterValueResolver(ComponentParameterization<?> actingParameter, ParameterizedModel parameterizedModel, Supplier<Optional<ConfigurationInstance>> configurationInstance) throws MuleException {
        ResolverSet resolverSet = ResolverSetUtils.getResolverSetFromComponentParameterization(actingParameter, this.muleContext, true, this.reflectionCache, this.expressionManager, parameterizedModel.getName());
        return new DesignTimeParameterValueResolver(resolverSet, parameterizedModel, this.reflectionCache, this.expressionManager, configurationInstance);
    }

    @Override
    public ResolverSet createParametersResolverSetFromValues(Map<String, ?> values, ParameterizedModel parameterizedModel) throws ConfigurationException, InitialisationException {
        ParametersResolver parametersResolver = ParametersResolver.fromValues(values, this.muleContext, true, this.reflectionCache, this.expressionManager, parameterizedModel.getName());
        ResolverSet typeUnsafeResolverSet = parametersResolver.getParametersAsResolverSet(this.muleContext, parameterizedModel, parameterizedModel.getParameterGroupModels());
        Map paramModels = parameterizedModel.getAllParameterModels().stream().collect(Collectors.toMap(p -> p.getName(), Function.identity()));
        ResolverSet typeSafeResolverSet = new ResolverSet(this.muleContext);
        typeUnsafeResolverSet.getResolvers().forEach((paramName, resolver) -> {
            Optional clazz;
            ParameterModel model = (ParameterModel)paramModels.get(paramName);
            if (model != null && (clazz = ExtensionMetadataTypeUtils.getType((MetadataType)model.getType())).isPresent()) {
                resolver = new TypeSafeValueResolverWrapper((ValueResolver)resolver, (Class)clazz.get());
            }
            typeSafeResolverSet.add((String)paramName, (ValueResolver)resolver);
        });
        typeSafeResolverSet.initialise();
        return typeSafeResolverSet;
    }

    @Override
    public ValueProviderMediator createValueProviderMediator(ParameterizedModel parameterizedModel) {
        return new DefaultValueProviderMediator<ParameterizedModel>(parameterizedModel, () -> this.muleContext, () -> this.reflectionCache);
    }

    @Override
    public SampleDataProviderMediator createSampleDataProviderMediator(ExtensionModel extensionModel, ComponentModel componentModel, Component component, StreamingManager streamingManager) {
        return new DefaultSampleDataProviderMediator(extensionModel, componentModel, component, this.muleContext, this.reflectionCache, streamingManager);
    }

    @Override
    public MetadataContext createMetadataContext(Supplier<Optional<ConfigurationInstance>> configurationSupplier, ConnectionManager connectionManager, MetadataCache cache, ClassTypeLoader typeLoader) {
        return new DefaultMetadataContext(configurationSupplier, connectionManager, cache, typeLoader);
    }

    @Override
    public MetadataContext createMetadataContext(Supplier<Optional<ConfigurationInstance>> configurationSupplier, ConnectionManager connectionManager, MetadataCache cache, ClassTypeLoader typeLoader, Optional<ScopeOutputMetadataContext> scopeOutputMetadataContext, Optional<RouterOutputMetadataContext> routerOutputMetadataContext) {
        return new DefaultMetadataContext(configurationSupplier, connectionManager, cache, typeLoader, scopeOutputMetadataContext, routerOutputMetadataContext);
    }

    @Override
    public <CM extends ComponentModel> MetadataMediator createMetadataMediator(CM componentModel) {
        return new DefaultMetadataMediator<CM>(componentModel, this.reflectionCache);
    }

    @Override
    public <T> T createTopLevelComponent(ComponentParameterization componentParameterization, String componentName, Class<T> componentClass) throws Exception {
        ClassLoader classLoader = componentClass.getClassLoader();
        return (T)ClassUtils.withContextClassLoader((ClassLoader)classLoader, () -> {
            String parametersOwner = "";
            ResolverSet resolverSetFromComponentParameterization = ResolverSetUtils.getResolverSetFromComponentParameterization(componentParameterization, this.muleContext, false, this.reflectionCache, this.expressionManager, parametersOwner);
            JavaTypeLoader javaTypeLoader = new JavaTypeLoader(classLoader);
            ObjectType objectType = (ObjectType)javaTypeLoader.load((Type)componentClass);
            ParametersResolver parametersResolver = this.parametersResolverFromValues(this.normalize(resolverSetFromComponentParameterization.getResolvers()), parametersOwner);
            DefaultObjectBuilder builder = new DefaultObjectBuilder(componentClass, this.reflectionCache);
            this.resolveParameters(objectType, builder, parametersResolver);
            this.resolveParameterGroups(objectType, builder, parametersResolver);
            builder.setName(componentName);
            ObjectBuilderValueResolver resolver = new ObjectBuilderValueResolver(builder, this.muleContext);
            CoreEvent initialiserEvent = NullEventFactory.getNullEvent();
            try {
                ValueResolvingContext ctx = ValueResolvingContext.builder(initialiserEvent, this.expressionManager).build();
                try {
                    Object staticProduct = resolver.resolve(ctx);
                    this.muleContext.getInjector().inject(staticProduct);
                    Object t = staticProduct;
                    if (ctx != null) {
                        ctx.close();
                    }
                    return t;
                }
                catch (Throwable throwable) {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            finally {
                if (initialiserEvent != null) {
                    ((BaseEventContext)initialiserEvent.getContext()).success();
                }
            }
        }, Exception.class, exception -> {
            throw exception;
        });
    }

    private void resolveParameterGroups(ObjectType objectType, DefaultObjectBuilder builder, ParametersResolver parametersResolver) {
        parametersResolver.resolveParameterGroups(objectType, builder);
    }

    private void resolveParameters(ObjectType objectType, DefaultObjectBuilder builder, ParametersResolver parametersResolver) {
        parametersResolver.resolveParameters(objectType, builder);
    }

    private ParametersResolver parametersResolverFromValues(Map<String, ValueResolver<?>> resolvers, String parametersOwner) {
        return ParametersResolver.fromValues(resolvers, this.muleContext, this.reflectionCache, this.expressionManager, parametersOwner);
    }

    private Map<String, ValueResolver<?>> normalize(Map<String, ValueResolver<?>> parameters) {
        HashMap normalized = new HashMap();
        parameters.forEach((key, value) -> {
            String normalizedKey = key;
            if (DefaultExtensionDesignTimeResolversFactory.isChildKey(key)) {
                normalizedKey = DefaultExtensionDesignTimeResolversFactory.unwrapChildKey(key);
                normalized.put(normalizedKey, (ValueResolver<?>)value);
            } else if (!normalized.containsKey(normalizedKey)) {
                normalized.put(normalizedKey, (ValueResolver<?>)value);
            }
        });
        return normalized;
    }

    private static boolean isChildKey(String key) {
        return key.startsWith(CHILD_ELEMENT_KEY_PREFIX) && key.endsWith(CHILD_ELEMENT_KEY_SUFFIX);
    }

    private static String unwrapChildKey(String key) {
        return key.replaceAll(CHILD_ELEMENT_KEY_PREFIX, "").replaceAll(CHILD_ELEMENT_KEY_SUFFIX, "");
    }
}

