/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.discoverer;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.api.manager.ServiceRegistry;
import org.mule.runtime.module.service.internal.discoverer.ServiceResolver;
import org.mule.runtime.module.service.internal.manager.LazyServiceProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionServiceResolver
implements ServiceResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionServiceResolver.class);
    private final ServiceRegistry serviceRegistry;
    private final Injector containerInjector;
    private final BiFunction<Service, ServiceAssembly, Service> serviceWrapper;

    public ReflectionServiceResolver(ServiceRegistry serviceRegistry, Injector containerInjector, BiFunction<Service, ServiceAssembly, Service> serviceWrapper) {
        this.serviceRegistry = serviceRegistry;
        this.containerInjector = containerInjector;
        this.serviceWrapper = serviceWrapper;
    }

    @Override
    public List<Service> resolveServices(List<ServiceAssembly> assemblies) {
        ArrayList<Service> services = new ArrayList<Service>(assemblies.size());
        for (ServiceAssembly assembly : assemblies) {
            try {
                Service service = this.serviceWrapper.apply(LazyServiceProxy.from(assembly, this.serviceRegistry, this.containerInjector), assembly);
                this.serviceRegistry.register(service, assembly.getServiceContract());
                services.add(service);
            }
            catch (MuleRuntimeException e) {
                if (e.getCause() instanceof ClassNotFoundException) {
                    LOGGER.debug("Contract class not available for service {}", (Object)assembly.getName());
                    LOGGER.debug("Exception was:", e.getCause());
                    continue;
                }
                throw e;
            }
        }
        return services;
    }
}

