/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.ref.WeakReference;
import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.internal.streaming.CursorManager;
import org.mule.runtime.core.internal.streaming.CursorUtils;
import org.mule.runtime.core.internal.streaming.ManagedCursorProvider;
import org.mule.runtime.core.internal.streaming.StreamingGhostBuster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStreamingState {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventStreamingState.class);
    protected final Cache<Integer, WeakReference<ManagedCursorProvider>> providers = Caffeine.newBuilder().build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Cursor> ManagedCursorProvider<T> addProvider(ManagedCursorProvider<T> provider, StreamingGhostBuster ghostBuster) {
        int id = provider.getId();
        ManagedCursorProvider<T> managedProvider = this.getOrAddManagedProvider(id, provider, ghostBuster);
        if (managedProvider == null) {
            CursorProvider<T> cursorProvider = CursorUtils.unwrap(provider);
            synchronized (cursorProvider) {
                managedProvider = this.getOrAddManagedProvider(id, provider, ghostBuster);
                if (managedProvider == null) {
                    this.providers.invalidate((Object)id);
                    managedProvider = this.getOrAddManagedProvider(id, provider, ghostBuster);
                }
            }
        }
        return managedProvider;
    }

    private <T extends Cursor> ManagedCursorProvider<T> getOrAddManagedProvider(int id, ManagedCursorProvider<T> provider, StreamingGhostBuster ghostBuster) {
        return (ManagedCursorProvider)((WeakReference)this.providers.get((Object)id, k -> {
            if (CursorManager.STREAMING_VERBOSE) {
                CursorProvider innerDelegate = CursorUtils.unwrap(provider);
                Optional<ComponentLocation> originatingLocation = provider.getOriginatingLocation();
                LOGGER.info("Added ManagedCursorProvider: {} for delegate: {} opened by: {}", new Object[]{k, System.identityHashCode(innerDelegate), originatingLocation.map(ComponentLocation::getLocation).orElse("unknown")});
            }
            return ghostBuster.track(provider, () -> this.providers.invalidate((Object)id));
        })).get();
    }

    public void dispose() {
        this.providers.asMap().forEach((hash, weakReference) -> {
            ManagedCursorProvider provider = (ManagedCursorProvider)weakReference.get();
            if (provider != null) {
                weakReference.clear();
                provider.releaseResources();
            }
        });
    }
}

